import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';

/**
 * 巡检首页-图表
 *
 * @class PatrolChart
 * @extends {Component}
 */
class AlarmLineChart extends Component {
  constructor(props) {
    super(props);

  }

  getOption = () => {
    const { data } = this.props;
    const { xAxis, urgent, important, secondary, warning } = data || {};
    return {
      grid: {
        top: '40px',
        bottom: '10px',
        containLabel: true
      },
      tooltip: {
        trigger: 'axis',
        axisPointer: {
          type: 'shadow'
        }
      },
      legend: {
        icon: 'circle',
        // itemWidth: 14,
        // itemHeight: 5,
        // itemGap: 13,
        textStyle: {
          color: 'white',
          fontSize: 14
        },
        data: ['紧急', '重要', '次要','警告']

      },
      xAxis: {
        type: 'category',
        data: xAxis,
        axisLabel: {
          interval: 0,
          show: true,
          textStyle: {
            color: 'white',
            fontSize: 13
          }
        },
        axisLine: {
          lineStyle: {
            show: false,
            color: '#494d54',
            width: 1
          }
        }
      },
      yAxis: [{
        nameLocation: 'middle',
        nameTextStyle: {
          'color': '#AEA4A8'
        },
        axisLabel: {
          interval: 0,
          show: true,
          textStyle: {
            color: 'white',
            fontSize: 13
          }
        },
        axisLine: {
          show: false,
          textStyle: {
            color: 'white',
            fontSize: 13
          }
        },
        axisTick: {
          show: false
        },
        splitLine: {
          lineStyle: {
            color: '#e6e6e6',
            width: 1
          }
        }
      }
      ],
      series: [{
        name: '紧急',
        type: 'line',
        smooth: true,
        barGap: 0,
        barWidth: '30%',
        label: {
          normal: {
            show: true,
            position: 'top',
            color: '#dc143c',
            align: 'center'
          }
        },
        itemStyle: {
          normal: {
            color: '#dc143c',
            barBorderRadius: 11
          }
        },
        data: urgent
      },
      {
        name: '重要',
        type: 'line',
        smooth: true,
        barGap: 0,
        barWidth: '30%',
        label: {
          normal: {
            show: true,
            position: 'top',
            color: '#ff7f50',
            align: 'center'
          }
        },
        itemStyle: {
          normal: {
            color: '#ff7f50',
            barBorderRadius: 11
          }
        },
        data: important
      },{
        name: '次要',
        type: 'line',
        smooth: true,
        barGap: 0,
        barWidth: '30%',
        label: {
          normal: {
            show: true,
            position: 'top',
            color: '#ffd700',
            align: 'center'
          }
        },
        itemStyle: {
          normal: {
            color: '#ffd700',
            barBorderRadius: 11
          }
        },
        data: secondary
      },{
        name: '警告',
        type: 'line',
        smooth: true,
        barGap: 0,
        barWidth: '30%',
        label: {
          normal: {
            show: true,
            position: 'top',
            color: '#00ced1',
            align: 'center'
          }
        },
        itemStyle: {
          normal: {
            color: '#00ced1',
            barBorderRadius: 11
          }
        },
        data: warning
      }]
    };
  }

  render() {
    console.log(this.getOption());
    return (
      <div className="alarmLineChart">
        <AmosEcharts option={this.getOption()} />
      </div>
    );
  }
}
AlarmLineChart.propTypes = {
  data: PropTypes.object
};


AlarmLineChart.defaultProps = {
  data: []
};


export default AlarmLineChart;
