import { Toast, Paragraph } from 'amos-framework';
import React from 'react';
import '../../../../styles/view/3dview/notification.scss';
import RiskWarnModal from '../points/dialogModel/RiskWarnModal';

const conf = {
  duration: 5
};

/**
 * 风险触发预警详情
 *
 * @param {*} id 风险触发预警ID
 */
function openRiskWarningModel(id) {
  Toast.open({
    title: '风险触发预警详情',
    content: <RiskWarnModal riskSourceId={id} />,
    placement: 'topMiddle',
    icon: false,
    className: 'risk-warn-toast',
    duration: null
  });
}

/**
 * 弹出消息框
 *
 * @export
 * @param {*} msg 消息对象
 */
export default function globalMsg(msg){
  const { title, content, duration = conf.duration, bizclassName } = msg.data;
  const { id } =  msg.bizObj;
  if (title && content) {
    Toast.error({
      title,
      content: <Paragraph html={content} />,
      placement: 'topMiddle',
      icon: false,
      duration,
      onClick: bizclassName && bizclassName.indexOf('RiskSourceRo') !== -1 ? ()=>openRiskWarningModel(id) : ()=>{}
    });
  }
}
