import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'amos-framework';
import PickModal from './PickModal';


/**
 * 坐标拾取弹出框
 *
 * @class PickDialog
 * @extends {Component}
 */
class PickDialog extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: this.props.visible || false
    };
  }

  componentDidMount(){
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.visible !== this.state.visible){
      this.setState({
        visible: nextProps.visible
      });
    }
  }

  onOk = () => {
    this.model.handleSubmit();
  }

  getContext = (pickedPosition, floorType, orgCode) => {
    return <PickModal pickedPosition={pickedPosition} floorType={floorType} orgCode={orgCode} ref={component => this.model = component} onCancel={this.cancel} />;
  };

  cancel = () => {
    this.setState({ visible: false });
    this.props.onClose();
  };

  render() {
    const { visible } = this.state;
    const { pickedPosition, floorType, orgCode } = this.props;

    let modelClass = 'pick-dialog-modal';
    return (
      <Modal header="坐标拾取"
        visible={visible}
        className={modelClass}
        destroyContent
        content={this.getContext(pickedPosition, floorType, orgCode)}
        onCancel={this.cancel}
        onOk={() => this.onOk()}
        okText="提交"
        cancelText="取消"
        outterClosable={false}
      />
    );
  }
}

PickDialog.propTypes = {
  orgCode: PropTypes.string,
  floorType: PropTypes.string,
  pickedPosition: PropTypes.array,
  visible: PropTypes.bool,
  onClose: PropTypes.func
};

export default PickDialog;
