import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { utils, consts } from 'amos-tool';
import classNames from 'classnames';
import imgStatic from 'CONSTS/imgStatic';

const markerIoncMapper = imgStatic.markers;

const getIcon = (markerType, level) => {
  if (markerType === 'riskSource' || markerType === 'patrol' || markerType === 'impEquipment' || markerType === 'dynamicRingData') {
    return markerIoncMapper[`${markerType}_${level}`];
  }
  return markerIoncMapper[`${markerType}`];
};

/**
 * 点标记图标
 *
 * @class MarkerIcon
 * @extends {Component}
 */
class MarkerIcon extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showInfo: props.showInfo,
      showRiskName: false
    };
  }

  componentWillMount = () => {
    const { title, type } = this.props;
    this.setState({ title, type });
  };

  componentWillReceiveProps = nextProps => {
    const { showInfo } = nextProps;
    this.setState(showInfo);
  };

  onMouseOver = () => {
    this.setState({ showRiskName: true, showInfo: true });
  };

  onMouseLeave = () => {
    const { title, type } = this.state;
    if (type === 'patrol' && (title.includes('miss') > 0 || title.includes('offGrade') > 0)) {
      this.setState({ showRiskName: false });
    } else if ((type === 'riskSource') && this.props.showInfo) {
      this.setState({ showRiskName: false });
    } else {
      this.setState({ showInfo: false, showRiskName: false });
    }
  };

  renderTitle = (title, label, showRiskName, type, showInfo, twinkle) => {
    if (type === 'riskSource') {
      if (showInfo) {
        if (showRiskName) {
          return (
            <div className="marker-icon-title" style={{ zIndex: 1000 }}>
              <div className="title-text">{label}</div>
            </div>
          );
        } else {
          twinkle = true;
          return (
            <div className="marker-icon-title" style={{ zIndex: 1000 }}>
              <div className="title-text">{'风险值' + parseInt(title)}</div>
            </div>
          );
        }
      }
    } else {
      if (utils.isString(title) && showInfo) {
        return (
          <div className="marker-icon-title" style={{ zIndex: 1000 }}>
            <div className="title-text">{title}</div>
          </div>
        );
      }
    }
  };

  render() {
    const { markerType, title, level, twinkle, label, type,rate = 0 } = this.props;
    const { showInfo, showRiskName } = this.state;
    const second = rate === 0 ? 0 : 1 / rate;
    const style = {
      background: `url(${getIcon(markerType, level)}) no-repeat`,
      backgroundSize: 'contain'
    };
    const cls = classNames('marker-icon', {
      'marker-anim': second > 0 ? true : twinkle
    });
    if (showInfo) {
      return (
        <div className={cls} style={style} onMouseLeave={this.onMouseLeave} onMouseOver={this.onMouseOver}>
          {this.renderTitle(title, label, showRiskName, type, showInfo, twinkle)}
          {(second > 0 || twinkle) && <div className="pulse-spread" />}
        </div>
      );
    }
    return (
      <div className={cls} style={style} onMouseOver={this.onMouseOver}>
        {this.renderTitle(title, label, showRiskName, type, showInfo, twinkle)}
        {(second > 0 || twinkle) && <div className="pulse-spread" />}
      </div>
    );
  }
}

MarkerIcon.propTypes = {
  markerType: PropTypes.string,
  showInfo: PropTypes.bool,
  subscribe: PropTypes.func,
  title: PropTypes.oneOfType([PropTypes.string, PropTypes.arrayOf(PropTypes.string)]),
  level: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  twinkle: PropTypes.bool,
  label: PropTypes.string,
  type: PropTypes.string,
  rate: PropTypes.number
};

export default MarkerIcon;
