/* eslint-disable react/sort-comp */
/* eslint-disable react/jsx-no-undef */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { pointInfoAction } from 'SERVICES/3dService';
import { CONSTS } from 'CONSTS/storageConsts';
import { queryRoutePlanPointAction } from 'SERVICES/checkInfoService';
import { Modal } from 'amos-framework';
import Dialog from '../dialog';
import VideoDialog from '../videoDialog';
import RiskContent from './RiskContent';
import { tirggerTransTopic } from '../dataProcessor';
import RiskContentTable from './dialogModel/RiskContentTable';
import MonitorEquipmentModal from './dialogModel/MonitorEquipmentModal';
import EquipmentModal from './dialogModel/EquipmentModal';
import DynamicRingDateModalTable from './dialogModel/DynamicRingDateModalTable';
import RiskSourceDetailModal from './dialogModel/RiskSourceDetailModal';
import CheckDetail from './../../../bizview/check/checkDetail/index';
import { eventTopics } from '../consts';
import { PubSub } from 'ray-eventpool';

const headers = [{ key: 'details', icon: 'number-more', text: '详情' }, { key: 'danger', icon: 'danger', text: '隐患' }];

const dialogEum = {
  riskSource: '风险详情',
  patrol: '巡检点',
  impEquipment: '设备',
  monitorEquipment: '数据点',
  video: '视频点',
  dynamicRingData: '动环数据',
  huotan: '火探'
};

/**
 * 标记点模态框
 *
 * @class PointDialog
 * @extends {Component}
 */
class PointDialog extends Component {
  constructor(props) {
    super(props);
    this.state = {
      open: false,
      showRight: false,
      rightContent: null,
      markerData: {},
      modal: false,
      dialog: false,
      isFullScreen: false,
      fireDetectVisible: false,
      xun: false,
      checkId: ''
    };
  }

  componentDidMount() {
    PubSub.subscribe(eventTopics.innate_operater_back, (topic, data) => {
      this.onDialogClose();
    });
  }

  /**
   * 打开模态框
   *
   * @memberof PointDialog
   */
  onOpenClick = marker => {
    const { id, type, objType, sourceId, orgCode } = marker.extData || {};
    if (type === 'patrol') {
      this.setState(
        { open: true },
        () => {
          pointInfoAction(id, type).then(d => {
            d.markerExtData = { dialogId: id, type };
            this.setState({ markerData: d });
          });
          this.getTableData(id, orgCode);
        }
      );
    } else if (type === 'video') {
      let markerData = {};
      markerData.markerExtData = marker.extData;//{ dialogId: id, type, objType };
      this.setState({ markerData, dialog: true });
    } else if (type in dialogEum) {
      let markerData = {};
      markerData.markerExtData = { dialogId: id, type, objType, sourceId };
      if (type === 'riskSource') {
        this.setState({ markerData, modal: true });
      } else if (type === 'impEquipment' && objType !== '03') {//虚拟设备不需要打开Model框
        this.setState({ markerData, modal: true });
      } else if (type === 'dynamicRingData') {//
        this.setState({ markerData, modal: true });
      }
    }
  };

  /**
   * 关闭模态框
   *
   * @memberof PointDialog
   */
  onDialogClose = () => {
    this.setState({
      open: false,
      showRight: false,
      rightContent: null,
      markerData: {}
    });
  };

  /**
   * 获取目标信息
   *
   * @memberof PointDialog
   */
  getTargetInfo = key => {
    const { markerData = {} } = this.state;
    return markerData.name;
  };

  /**
   * 状态点击事件
   *
   * @memberof PointDialog
   */
  onCheckStatusClick = record => {
    this.setState({ xun: true, checkId: record.id });
    // const detailParams = {
    //   ...markerData.markerExtData,
    //   detailForw: 'record',
    //   checkId: record.id
    // };
    // tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
  };

  /**
   * 获取目标信息
   *
   * @memberof PointDialog
   */
  getTargetInfo = key => {
    const { markerData = {} } = this.state;
    const info = markerData.info || [];
    return (info.find(i => i.key === key) || {}).value;
  };

  /**
   * 获取内容
   *
   * @memberof PointDialog
   */
  getContext = markerData => {
    const { type, dialogId, objType, sourceId } = markerData.markerExtData || {};
    let obj = {};
    switch (type) {
      case 'monitorEquipment':
        obj = <MonitorEquipmentModal type="monitorEquipment" dialogId={dialogId} />;
        break;
      case 'riskSource':
        obj = <RiskSourceDetailModal type="riskSource" riskSourceId={dialogId} />;
        break;
      case 'impEquipment':
        obj = <EquipmentModal objType={objType} type="impEquipment" dialogId={dialogId} sourceId={sourceId} />;
        break;
      case 'dynamicRingData':
        obj = <DynamicRingDateModalTable objType={objType} type="dynamicRingData" dialogId={dialogId} />;
        break;
      default:
        console.log('不支持的类型');
    }
    return obj;
  };

  /**
   * 获取表格数据
   *
   * @memberof PointDialog
   */
  getTableData = (pointId, orgCode) => {
    pointId &&
      queryRoutePlanPointAction([{ name: 'pointID', value: pointId }, { name: 'orgCode', value: orgCode }]).then(data => {
        this.setState({ dataList: data });
      });
  };

  /**
   * 取消
   *
   * @memberof PointDialog
   */
  cancel = () => {
    this.setState({ modal: false });
  };

  /**
   * 巡检详情
   */
  cancelxun = () => {
    this.setState({ xun: false });
  };

  /**
   * 全屏切换
   *
   * @memberof PointDialog
   */
  clickFullScreen = () => {
    this.setState({ isFullScreen: !this.state.isFullScreen });
  }

  /**
   * 取消
   *
   * @memberof PointDialog
   */
  close = () => {
    this.setState({ dialog: false, isFullScreen: false });
  };

  /**
   * 顶部点击事件
   *
   * @memberof PointDialog
   */
  clickHeaderItem = key => {
    const { markerData } = this.state;
    // 如果点击详情则和业务屏交互
    const detailParams = {
      ...markerData.markerExtData,
      detailForw: key
    };
    if (key === 'details') {
      tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
    } else if (key === 'danger') {
      const name = this.getTargetInfo('name');
      tirggerTransTopic(CONSTS.forward, {
        name,
        details: detailParams,
        dateTime: Date.now()
      });
    } else if (key === 'record') {
      tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
    }
  };

  render() {
    const { open, checkId, xun, showRight, rightContent, markerData, modal, dataList, dialog, isFullScreen, fireDetectVisible } = this.state;
    const { type, dialogId, objType } = markerData.markerExtData || {};
    let minInfo = {
      headers,
      title: dialogEum[type],
      content: <RiskContent markerData={markerData} />,
      table: <RiskContentTable pointId={dialogId} dataList={dataList} onCheckStatusClick={this.onCheckStatusClick} fetchData={this.getTableData} />
    };
    let modelClass = 'point-dialog-modal';
    if (type === 'riskSource' || type === 'patrol') {
      modelClass = 'risk-warn-modal';
    } else if (type === 'impEquipment') {
      modelClass = 'impEqu-info-modal';
    } else if (type === 'dynamicRingData' && objType === '01') {
      modelClass = 'dynamicRingData-info-modal';
    } else if (type === 'dynamicRingData' && objType === '02') {
      modelClass = 'dynamicRingData-fire-info-modal';
    }

    let header = '';
    if (type === 'dynamicRingData' && objType === '01') {
      header = dialogEum['dynamicRingData'];
    } else if (type === 'dynamicRingData' && objType === '02') {
      header = dialogEum['huotan'];
    } else {
      header = dialogEum[type];
    }
    //console.log(type,fireDetectVisible);

    let ff = true;
    return (
      <div>
        {
          <Dialog
            visible={open}
            minInfo={minInfo}
            showMax={showRight}
            maxContent={rightContent}
            closeDialog={this.onDialogClose}
            clickHeaderItem={this.clickHeaderItem}
          />
        }
        {<Modal
          className='xun'
          header="巡检详情"
          visible={xun}
          noDefaultFooter
          destroyContent
          width='1200px'
          onCancel={this.cancelxun}
          content={<CheckDetail pointId={dialogId} checkID={checkId} />}
        />
        }
        {type && type !== 'video' && (
          <Modal
            header={header}
            visible={modal}
            className={modelClass}
            destroyContent
            content={this.getContext(markerData)}
            noDefaultFooter
            onCancel={this.cancel}
          />
        )}
        {type === 'video' && (
          <VideoDialog
            visible={dialog}
            title={markerData.markerExtData.title}
            data={markerData.markerExtData}
            closeDialog={this.close}
            isFullScreen={isFullScreen}
            clickFullScreen={this.clickFullScreen}
          />
        )}
      </div>
    );
  }
}

PointDialog.propTypes = {
  subscribe: PropTypes.func
};

export default PointDialog;
