/* eslint-disable react/jsx-no-bind */
/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import AmosGridTable from '../../../../bizview/common/tableComponent/table/AmosGridTable';

const checkListColumns = (self) => {
  return [
    {
      title: '巡检路线',
      dataIndex: 'routeName',
      key: 'routeName',
      width: '20%'
    },
    {
      title: '巡检计划',
      dataIndex: 'planName',
      key: 'planName',
      width: '20%'
    },
    {
      title: '执行部门',
      dataIndex: 'deptName',
      key: 'deptName',
      width: '14%'
    },
    {
      title: '执行人',
      dataIndex: 'userName',
      key: 'userName',
      width: '13%'
    },
    {
      title: '巡检时间',
      dataIndex: 'checkTime',
      key: 'checkTime',
      width: '23%'
    },
    {
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      width: '10%',
      render(text, record, index) {

       if(text==='合格'){
        text='正常';
       }else if(text==='不合格'){
        text='异常';
       }




        return <span><a href="javascript:;" onClick={function() { self.onCheckStatusClick(record); }}>


        {text}

          </a></span>;
      }
    }
  ];
};

/**
 * 巡检内容
 *
 * @class RiskContentTable
 * @extends {Component}
 */
class RiskContentTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      selectedRowKeys: []
    };
  }

  /**
   * 状态点击事件
   */
  onCheckStatusClick =(record)=>{
    this.props.onCheckStatusClick(record);
  }

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  render() {
    const { dataList } = this.props;
    return (
      <div>
        <AmosGridTable
          columns={checkListColumns(this)}
          getTableDataAction={()=>{}}
          callBack={this.reload}
          isPageable={false}
          isChecked={false}
          dataList={dataList}
        />
      </div>
    );
  }
}

export default RiskContentTable;
