import React, { Component } from 'react';
import AmosGridTable from '../../../../bizview/common/tableComponent/table/AmosGridTable';
import { riskSoureDetail3dAction } from 'SERVICES/bizService';

const checkListColumns = (self) => {
  return [
    {
      title: '可能诱发的风险',
      dataIndex: 'riskFactor',
      key: 'riskFactor',
      width: '20%'
    },{
      title: '可能导致的事故',
      dataIndex: 'accidentType',
      key: 'accidentType',
      width: '20%'
    },{
      title: '事故严重程度',
      dataIndex: 'severity',
      key: 'severity',
      width: '18%'
    },{
      title: '事故发生的概率',
      dataIndex: 'occurrence',
      key: 'occurrence',
      width: '12%'
    }
  ];
};

/**
 * 预警
 *
 * @class RiskWarnModal
 * @extends {Component}
 */
class RiskWarnModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      selectedRowKeys: []
    };
  }

  componentDidMount(){
    // eslint-disable-next-line react/prop-types
    let { riskSourceId } = this.props;
    this.queryRiskSoureWarning(parseInt(riskSourceId));
  }

  queryRiskSoureWarning =(riskSourceId)=>{
    // queryRiskSoureWarningAction(riskSourceId).then(data =>{
      // this.setState({ dataList: data.fmeaList, riskSourceInfo: data.riskSourceInfo, inputitemContent: data.inputitemContent, alarm: data.fire_equipment });
    // });
    riskSoureDetail3dAction(riskSourceId).then(data =>{
      this.setState({ data });
    });
  }

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  renderCheck =(inputitemContent)=>{
    return inputitemContent.map(item =>{
      return (<p>
        <span>{item.label} &nbsp;</span>
        <span>{item.content}</span>
        {/* <span style={{ color: '#FF0000' }}>{item.label}</span> */}
      </p>);
    });
  }

  renderEquipWaring =(alarm)=>{
    return alarm.map(item =>{
      return (<p>
        <span>{item.fireEquipmentName}：</span>
        <span style={{ color: '#FF0000' }}>{item.name}-不合格</span>
      </p>);
    });
  }

  render() {
    const { data = {} } = this.state;
    return (
      <div className="risk-warn">
        <div className="risk-warn-header">
          <p>
            <span style={{ fontWeight: 'bold' }}>风险编号：</span>
            <span>{data.code}&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span>
            <span style={{ fontWeight: 'bold' }}>风险名称：</span>
            <span>{data.name}&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span>
            <span style={{ fontWeight: 'bold' }}>级别：</span>
            <span>{data.level}</span>
          </p>
        </div>
        <div className="risk-warn-table">
          <AmosGridTable
            columns={checkListColumns(this)}
            getTableDataAction={()=>{}}
            callBack={this.reload}
            isPageable={false}
            isChecked={false}
            dataList={data.riskFactors || []}
          />
        </div>
        <div className="risk-warn-content">
          <p>
            <span>风险诱发原因：</span>
          </p>
          {data.riskFactorsControlMeasures && this.renderCheck(data.riskFactorsControlMeasures)}
        </div>
      </div>
    );
  }
}

export default RiskWarnModal;
