/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import { IFrame } from 'amos-framework';
import { dialogDetailsAction } from 'SERVICES/checkService';

/**
 * 摄像头模态框
 *
 * @class VideoEquipmentModal
 * @extends {Component}
 */
class VideoEquipmentModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {}
    };
  }

  componentDidMount(){
    // let { dialogId, type } = this.props;
    // this.queryMarkerDetail(dialogId, type);
  }

  /**
   * 查询点标记详情
   *
   * @memberof VideoEquipmentModal
   */
  queryMarkerDetail =(dialogId,type)=>{
    dialogDetailsAction(dialogId,type).then(data =>{
      this.setState({ data });
    });
  }
  render() {
    const { data } = this.state;
    let position = '';
    if (Object.keys(data).length > 0){
      position = data.productionArea ? data.productionArea : position;
      position = data.floor3d ? `${position}-${data.floor3d}层` : position;
      position = data.room ? `${position}-${data.room}` : position;
      let begin = position.indexOf('-') >= 0 ? position.indexOf('-') + 1 : 0;
      position = position.substr(begin);
    }
    return (
      <div>
        <IFrame
          url="http://172.16.11.12:8001/monitor.html"
          width={310}
          height={175}
          id="iframeVideo"
          className="iframe-video"
          display="initial"
          position="relative"
          allowFullScreen
          scrolling="auto"
        />
      </div>
    );
  }
}

export default VideoEquipmentModal;
