import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col } from 'amos-framework';
import { dynamicRingDataDetail3dAction } from '../../../../../../services/3dService';

const bodtCxt = [
  { name: '失风报警',key: 'goWrongAlarm' },
  { name: '漏水报警',key: 'leakWaterAlarm' },
  { name: '低水位报警',key: 'lowHumidityAlarm' },
  { name: '综合报警输出',key: 'multipleAlarmOut' },
  { name: '过滤网报警',key: 'filteringNetAlarm' },
  { name: '高湿报警',key: 'highHumidityAlarm', },
  { name: '烟火报警',key: 'smokeAndFireAlarm', },
  { name: '低湿报警',key: 'lowWaterLevelAlarm', },
];
const getStatusImg = (status)=>{
  let obj = undefined;
  if(status === "正常"){
    obj = <img className='dynamicRingData-info-img' src='/src/assets/3dview/AlarmMesage1.png'/>
  }else if(status === "异常"){
    obj = <img className='dynamicRingData-info-img' src='/src/assets/3dview/AlarmMesage3.png'/>
  }else{
    obj = <img className='dynamicRingData-info-img' src='/src/assets/3dview/AlarmMesage5.png'/>
  }
  return obj
};

/**
 * 报警信息
 *
 * @class AlarmMessage
 * @extends {Component}
 */
class AlarmMessage extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: []
    };
  }

  componentDidMount(){
    const { equimentId } = this.props;
  }

  render() {
    const { data = [] } = this.props;
    return (
        <div className='dynamicRingData-AlarmMessage'>
            <Row className="dynamicRingData-baseInfo-row" >
            {/* {bodtCxt.map(item=>{
              return (
                      <Col span={12} className="colValue">{getStatusImg(data[item.key])}{item.name}</Col>
                    );
              })} */}
              {data && data.map(item=>{
              return (
                      <Col span={6} className="colValue">{getStatusImg(item.value)}{item.name}</Col>
                    );
              })} 
            </Row>
        </div>
    );
  }
}

AlarmMessage.propTypes = {

};

export default AlarmMessage;
