import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col } from 'amos-framework';
import { dynamicRingDataDetail3dAction } from '../../../../../../services/3dService';

const bodtCxt = [
  { name: '通讯状态',key: 'communication' },
];
const getStatusImg = (status)=>{
  let obj = undefined;
  if(status === "正常"){
    obj = <img className='dynamicRingData-info-img' src='/src/assets/3dview/AlarmMesage1.png'/>
  }else if(status === "异常"){
    obj = <img className='dynamicRingData-info-img' src='/src/assets/3dview/AlarmMesage3.png'/>
  }else{
    obj = <img className='dynamicRingData-info-img' src='/src/assets/3dview/AlarmMesage5.png'/>
  }
  return obj
};

/**
 * 其他信息
 *
 * @class OtherInfo
 * @extends {Component}
 */
class OtherInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: []
    };
  }

  componentDidMount(){
  }

  render() {
    const { data = [] } = this.props;
    return (
        <div className='dynamicRingData-otherInfo'>
            <Row className="dynamicRingData-baseInfo-row" >
              {/* {bodtCxt.map(item=>{
                return (
                        <Col span={12} className="colValue">{getStatusImg(data[item.key])}{item.name}</Col>
                      );
                })} */}
              {data && data.map(item=>{
                return (
                        <Col span={6} className="colValue">{getStatusImg(item.value)}{item.name}</Col>
                      );
                })}
            </Row>
        </div>
    );
  }
}

OtherInfo.propTypes = {

};

export default OtherInfo;
