import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col } from 'amos-framework';
import AmosGridTable from '../../../../../bizview/common/tableComponent/table/AmosGridTable';
import { euqipmentWarn3dAction } from '../../../../../../services/3dService';


const listColumns = (self) => {
    return [
        {
        title: '序号',
        render: (text, record, index) => `${index + 1}`,
        width: '6%'
      },
      {
        title: '严重度',
        dataIndex: 'alarmLevel',
        key: 'alarmLevel',
        render: (text, record, index) => {
                let color = '';
                if(text === '紧急告警'){
                    color = '#ff0000';
                }else if(text === '重要告警'){
                    color = 'coral';
                }else if(text === '次要告警'){
                    color = 'darkkhaki';
                }else if(text === '警告告警'){
                    color = '#0ff';
                }
            return <font style={{fontWeight:'bold'}} color={color}>{text}</font >},
        width: '10%'
      },{
        title: '告警原因',
        dataIndex: 'alarmReason',
        key: 'alarmReason',
        width: '14%'
      },{
        title: '告警类别',
        dataIndex: 'alarmSourceType',
        key: 'alarmSourceType',
        width: '10%'
      },{
        title: '当前状态',
        dataIndex: 'currentState',
        key: 'currentState',
        width: '10%'
      },{
        title: '产生时间',
        dataIndex: 'happenDate',
        key: 'happenDate',
        width: '10%'
      },{
        title: '持续时间',
        dataIndex: 'continueDate',
        key: 'continueDate',
        width: '10%'
      },{
        title: '确认时间',
        dataIndex: 'ensureDate',
        key: 'ensureDate',
        width: '10%'
      },{
        title: '确认人',
        dataIndex: 'ensurePerson',
        key: 'ensurePerson',
        width: '10%'
      },{
        title: '清除时间',
        dataIndex: 'clearDate',
        key: 'clearDate',
        width: '10%'
      }
    ];
  };

/**
 * 网络设备告警
 *
 * @class NetworkWarnTab
 * @extends {Component}
 */
class NetworkWarnTab extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 0,
      pageSize: 10
      };
    this.state = {
      totalCount: 0,
      data: []
    };
  }

  componentDidMount(){
    const { sourceId } = this.props;
    sourceId && this.queryEuqipmentWarn(sourceId);
  }

  queryEuqipmentWarn =(sourceId)=>{
    let pageSize = this.pageConfig.pageSize ;
    let current = this.pageConfig.current ;
    euqipmentWarn3dAction(sourceId, current, pageSize).then(data =>{
      this.setState({ data:data.content , totalCount:data.totalElements});
    });
  }

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  /**
   * 分页设置参数
   */
  setPageConfig = ({ pageSize, current }) => {
    debugger;
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.current = current - 1 ;
    }
  };

  render() {
    const { data, totalCount } = this.state;
    return (
        <div className="impEqu-info-table">
            <AmosGridTable
              columns={listColumns(this)}
              callBack={this.reload}
              isPageable={true}
              setPageConfig={this.setPageConfig}
              defaultPageConfig={this.pageConfig}
              isChecked={false}
              totals={totalCount}
              dataList={data || []}
              getTableDataAction={()=>{this.queryEuqipmentWarn(this.props.sourceId )}}
            />
        </div>
    );
  }
}

NetworkWarnTab.propTypes = {

};

export default NetworkWarnTab;
