import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { utils } from 'amos-tool';
import { Markers } from 'amos-3d/lib/designer';
import { CONSTS } from 'CONSTS/storageConsts';
import PointDialog from './PointDialog';
import { tirggerPlanTopic } from '../dataProcessor';
import { marker3DIoncMapper } from 'CONSTS/imgStatic';

const getIcon = (markerType, level) => {

  console.log(markerType, level);
  return marker3DIoncMapper[`${markerType}_${level}`];
};

const buildMarkerOptions = (markers, markerType, defaultParams = {}) => {
  if (!utils.isEmpty(markers)){
    markers.forEach(m => {
      console.log(m);
      const url = getIcon(markerType, m.level);
      console.log(url, 'url');
      let position;
      if (!utils.isArray(m.position)){
        position = Object.values(m.position);
      }
      for (let k of Object.keys(defaultParams)) {
        m[k] = defaultParams[k];
      }
      m.key = m.key || m.id;
      m.url = url;
      m.position = utils.isArray(m.position) ? m.position : position;
      m.size = 10;
    });
  }
  return markers;
};

export default function marker3DFactory(WrappedComponent = 'div', options){
  const { markerType, markerParams } = options;
  class MarkerPoints extends Component {

    static propTypes = {
      // marker 显隐
      visible: PropTypes.bool,
      markers: PropTypes.array,
      planStarted: PropTypes.bool
    };

    constructor(props) {
      super(props);
      this.markerEvents = {
        click: this.onMarkerClick,
        mouseover: (marker) => {
          marker.object2DPipe.pipeNode.visible = true;
          marker.object2DPipe.pipeNode.elementVisible = true;
        },
        mouseout: (marker) => {
          marker.object2DPipe.pipeNode.visible = false;
          marker.object2DPipe.pipeNode.elementVisible = false;
        }
      };
      this.state = {
        isClick: true
      };
    }

    componentWillMount = () => {
      this.setState({ planStarted: this.props.planStarted });
    }

    componentWillReceiveProps = nextProps => {
      this.setState({ planStarted: nextProps.planStarted });
    }

    onMarkerClick = (marker, e) => {
      const { isClick } = this.state;
      if (isClick) {
        this.setState({ isClick: false }); //将isClick 变成false，将不会执行处理事件
        this.pdRef && this.pdRef.onOpenClick(marker);
      }
      const that = this; // 为定时器中的setState绑定this
      setTimeout(function() {
        // 设置延迟事件，3秒后将执行
        that.setState({ isClick: true }); // 将isClick设置为true
      }, 3000);
      tirggerPlanTopic(CONSTS.plan_detail, { type: marker.extData.type, data: marker.extData });
    }

    render() {
      const { markers, ...rest } = this.props;
      const { planStarted } = this.state;
      let dialogStyle = { zIndex: 1000 };
      const result = buildMarkerOptions(markers, markerType, markerParams);
      return (
        <WrappedComponent>
          <Markers
            {...rest}
            markers={result}
            events={this.markerEvents}
          />
          { !planStarted && <PointDialog style={dialogStyle} ref={node => this.pdRef = node} />}
        </WrappedComponent>
      );
    }
  }

  return MarkerPoints;
}
