import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import imgStatic from 'CONSTS/imgStatic';
import { baseURI } from 'CONSTS/urlConsts';

const markerIoncMapper = imgStatic.markers;

const getIcon = (markerType) => {
  return markerIoncMapper[`${markerType}`];
};

/**
 * 火灾标记图标
 *
 * @class FireMarkerIcon
 * @extends {Component}
 */
class FireMarkerIcon extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showInfo: props.showInfo
    };
  }

  componentWillMount = () => {
    const { showInfo, title, show, url } = this.props;
    this.setState({ showInfo, title, show, url });
  };

  componentWillReceiveProps = nextProps => {
    const { showInfo, title, show, url } = nextProps;
    this.setState({ showInfo, title, show, url });
  };

  renderTitle = (title, show, url) => {
    return (
       void 0 === show ?  <div className="marker-icon-title"><div className="title-text">{title}</div> </div> : <div className="maker-top-img-div"><img src={baseURI + url} alt=""  className='maker-top-img' /> <p>{title}</p></div>
    );
  };

  render() {
    const { markerType, twinkle } = this.props;
    const { showInfo, title, show, url } = this.state;

    const style = {
      background: `url(${getIcon(markerType)}) no-repeat`,
      backgroundSize: 'contain'
    };
    const cls = classNames('marker-icon', {
      'marker-anim': twinkle
    });

    return (
      <div className={cls} style={style} >
        {showInfo && this.renderTitle(title, show, url)}
        {twinkle && <div className="pulse-spread" />}
      </div>
    );
  }
}

FireMarkerIcon.propTypes = {
  markerType: PropTypes.string,
  show: PropTypes.string,
  url: PropTypes.string,
  showInfo: PropTypes.bool,
  title: PropTypes.oneOfType([PropTypes.string, PropTypes.arrayOf(PropTypes.string)]),
  twinkle: PropTypes.bool
};

export default FireMarkerIcon;
