import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import imgStatic from '../../../../consts/imgStatic';
import TimerTool from './TimerTool';

const opeateIcon = imgStatic.opeateIcon;
let count = 0;
/**
 *
 * 交互区按钮
 * @class OperateButton
 * @extends {Component}
 */
class OperateButton extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount(){
    count = 0;
    this.registerTimer();
  }

  componentWillUnmount() {
    if (this.timer) {
      clearTimeout(this.timer);
    }
  }

  onButtonClick =(e,content)=>{
    e.stopPropagation();
    (this[content.code] || {}).initTime ? this[content.code].initTime() : '';
    if (this.timer) {
      clearTimeout(this.timer);
    }
    const { onButtonClick } = this.props;
    onButtonClick && onButtonClick(content);
  }

  onOpenButtonList =()=>{
    const { openStepCxt } = this.props;
    openStepCxt && openStepCxt();
  }

  registerTimer =()=> {
    this.timer && clearTimeout(this.timer);
    const { message = {} } = this.props;
    let json = message.buttonJson ? JSON.parse(message.buttonJson) : {};
    let button = json.operate[0] || [];
    button.batchNo = message.batchNo;
    button.contingencyPlanId = message.contingencyPlanId;
    button.stepCode = json.stepCode;
    let delayedArry = button.delayed || [];
    if (delayedArry.includes(count)) {
      this.props.onAutoClick(button, 'CANCEL_' + count);
    }
    if (delayedArry.length > 0 && count < Math.max.apply(null, delayedArry)){
      count = count + 1;
      this.timer = setTimeout(() => this.registerTimer(), 1000);
    }
  }

  autoClick = () => {
    const { message = {} } = this.props;
    let json = message.buttonJson ? JSON.parse(message.buttonJson) : {};
    let button = json.operate[0] || [];
    button.batchNo = message.batchNo;
    button.contingencyPlanId = message.contingencyPlanId;
    button.stepCode = json.stepCode;
    this.props.onAutoClick(button, 'CANCEL_' + button.hide);
  }

  hiddenButtonRoot =(message)=>{
    this.props.hiddPlanRoot(message);//隐藏button列表
    this.autoClick();//调用规则,通知按钮已挂起
  }

  renderBtn =(message) =>{
    let json = message.buttonJson ? JSON.parse(message.buttonJson) : {};
    let btnList = json.operate || [];
    if (btnList && btnList.length === 1) {
      btnList[0].batchNo = message.batchNo;
      btnList[0].contingencyPlanId = message.contingencyPlanId;
      btnList[0].stepCode = json.stepCode;
      return (<Button
        className="operate-button-button"
        transparent
        style={{ backgroundImage: 'url(' + opeateIcon.onlyOne + ')' }}
        onClick={(e)=>this.onButtonClick(e,btnList[0])}
      >
        {btnList[0].title}
      </Button>);
    } else if (btnList && btnList.length === 2) {
      return (btnList || []).map(btn =>{
        btn.batchNo = message.batchNo;
        btn.contingencyPlanId = message.contingencyPlanId;
        btn.stepCode = json.stepCode;
        return <Button
          className="operate-button-button"
          transparent
          key={btn.code}
          style={{ backgroundImage: 'url(' + opeateIcon[btn.icon] + ')' }}
          onClick={(e)=>this.onButtonClick(e,btn)}
        >{btn.title}</Button>;
      });
    }
  }

  render() {
    const { message = {} } = this.props;
    let display = message.hiddPlanButton ? 'none' :  '' ;
    let url = opeateIcon[message.icon];
    let json = message.buttonJson ? JSON.parse(message.buttonJson) : {};
    let btnJsonArry = json.operate || [];
    return (
      <div className={display ? 'operate-button-display-root' : 'operate-button-root'} onClick={this.onOpenButtonList} style={{ display }} >
        <div className='operate-button-left'>
          <img src={url}  alt='' onError={e => { e.target.onerror = null; e.target.style = 'display:none';}} />
          <div className='operate-button-content'>
            <div className="button-name">
              {message.actionName}
              {btnJsonArry.length > 0 && btnJsonArry[0].hide ? <TimerTool ref={timer =>this[message.contingencyPlanId] = timer} autoClick={() => this.hiddenButtonRoot(message)} delayed={btnJsonArry[0].hide} /> : ''}
            </div>
            <div className="button-desc">{message.tips}</div>
          </div>
        </div>
        <div className='operate-button-right' >{this.renderBtn(message)}</div>
      </div>
    );
  }
}

OperateButton.propTypes = {
  onButtonClick: PropTypes.func,
  message: PropTypes.object,
  openStepCxt: PropTypes.func,
  onAutoClick: PropTypes.func,
  style: PropTypes.object,
  hiddPlanRoot: PropTypes.func
};

export default OperateButton;
