import React, { Component } from 'react';
import { FatLine as Line } from 'amos-3d/lib/advanced';
import { initView3DLinkAction } from 'SERVICES/3dService';
import conf from './../conf';

class FatLine extends Component {

  constructor(props) {
    super(props);
    this.state = {
      links: []
    };
  }

  componentDidMount() {
    this.asyncLoadLink();
  }

  asyncLoadLink = () => {
    initView3DLinkAction().then(d => {
      this.setState({
        links: d
      });
    });
  }

  render() {
    const { links } = this.state;
    return links.map(l => {
      return <Line key={l.id} {...this.props} {...conf.link.fatlineProps} linePath={l.linkPath} />;
    });
  }
}

export default FatLine;
