import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { SidePane } from 'amos-framework';
import { Store } from 'amos-tool';
import BizControlPane from './BizControlPane';
import InnateControlPane from './InnateControlPane';
import { viewController, bizControls } from '../conf';
import { PubSub } from 'ray-eventpool';
import { eventTopics } from '../consts';

const loginUserName = Store.lsTool.read('userName');
const filterUser = ['tianbo', 'opera1', 'opera2'];

/**
 * 侧边控制区
 *
 * @class SideControl
 * @extends {Component}
 */
class SideControl extends Component {
  constructor(props) {
    super(props);
    this.state = {
      activeControl: [],
      open: true
    };
  }

  componentDidMount() {
    PubSub.subscribe(eventTopics.innate_operater_back, (topic, data) => {//监听三维返回按钮
      this.setState({
        open: false
      });
    });
  }

  /**
   * control 点击，第二次点击则取消
   */
  onBizItemClick = (item, e) => {
    const alreadyActive = this.isActive(item.key);
    const newKeys = this.getActiveControl(item.key, alreadyActive);
    this.setState({
      activeControl: newKeys
    });
    this.props.onItemClick && this.props.onItemClick(item, alreadyActive);
  };

  /**
   * control 选中
   *
   * @memberof SideControl
   */
  getActiveControl = (key, alreadyActive) => {
    const { multiple } = this.props;
    const { activeControl } = this.state;
    let newKeys = [];
    if (multiple) {
      newKeys = alreadyActive ? activeControl.filter(ac => ac !== key) : [...activeControl, key];
    } else {
      newKeys = alreadyActive ? [] : [key];
    }
    return newKeys;
  };

  /**
   * 是否选中
   *
   * @memberof SideControl
   */
  isActive = key => {
    const { activeControl, open } = this.state;
    if (!open){//2秒后初始activeControl和open
      setTimeout(()=>{
        this.setState({
          activeControl: [],
          open: true
        });
      }, 2000);
    }
    return open && activeControl && activeControl.includes(key);
  };

  render() {
    const { layerConfig, animationProps } = this.props;

    let _bizControls = bizControls;
    if (filterUser.includes(loginUserName)) {
      let target = _bizControls.find(item => item.key === 'fireResource-point');
      let subControls = target.subs;
      subControls = subControls.filter(item => item.key !== 'fireDetection');
      _bizControls.map(item => {
        if (item.key === 'fireResource-point') {
          item.subs = subControls;
        }
      });
    }
    return (
      <SidePane className="side-control-pane" {...animationProps}>
        <BizControlPane controls={_bizControls} isActive={this.isActive} onItemClick={this.onBizItemClick} />
        <InnateControlPane controls={viewController} layerConfig={layerConfig} />
      </SidePane>
    );
  }
}

SideControl.propTypes = {
  layerConfig: PropTypes.object,
  multiple: PropTypes.bool,
  onItemClick: PropTypes.func,
  write: PropTypes.func,
  toStr: PropTypes.func,
  animationProps: PropTypes.object
};

export default SideControl;
