import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Connect, IFrame } from 'amos-framework';
import Close from '../common/Close';
import FullScreen from '../common/FullScreen';
import { dialogDetailsAction } from 'SERVICES/checkService';
import LiverPlay from './../../../hikvideo/index';

const portalConnect = Connect.portalConnect;

/**
 * 视频弹出框
 *
 * @class DialogBody
 * @extends {Component}
 */
class VideoDialog extends Component {
  constructor(props) {
    super(props);
    this.state = {
      isFullScreen: props.isFullScreen || false,
      data: {}
    };
  }

  componentDidMount(){
    // let { dialogId, type } = this.props;
    // this.queryMarkerDetail(dialogId, type);
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.isFullScreen !== this.state.isFullScreen){
      this.setState({
        isFullScreen: nextProps.isFullScreen
      });
    }
  }

  /**
   * 关闭窗口
   *
   * @memberof VideoDialog
   */
  onClose = () => {
    this.props.closeDialog && this.props.closeDialog();
  }

  /**
   * 最大化最小化切换
   *
   * @memberof VideoDialog
   */
  onFullScreenClick = (e) => {
    this.props.clickFullScreen && this.props.clickFullScreen();
  }

  /**
   * 查询点标记详情
   *
   * @memberof VideoEquipmentModal
   */
  queryMarkerDetail =(dialogId,type)=>{
    dialogDetailsAction(dialogId,type).then(data =>{
      this.setState({ data });
    });
  }

  render() {
    const { title, isFullScreen, data } = this.props;
    console.log(data);
    const cls = classNames('dialog-body', {
      'show-body-max': isFullScreen
    });

    const width = isFullScreen ? '100%' : '310';
    const height = isFullScreen ? '100%' : '180';

    return (
      <div className={cls}>
        {
          <div className={!isFullScreen ? 'dialog-body-min' : 'dialog-body-max'}>
            <div className={!isFullScreen ? 'body-min-header' : 'body-max-header'}>
              <div className="common-title">{title}</div>
              <FullScreen onFullScreen={this.onFullScreenClick} isFullScreen={isFullScreen} />
              <Close onClose={this.onClose} />
            </div>
            <div className={!isFullScreen ? 'body-min-content' : 'body-max-content'}>
              {/* <video src={url} autoPlay width={width} height={height} controls="controls" /> */}
              <LiverPlay key={data.id} token={data.token} vedioId={data.id} width={width} height={height} />

              {/* <IFrame
                url={url}
                width={width}
                height={height}
                id="iframeVideo"
                className="iframe-video"
                display="initial"
                position="relative"
                allowFullScreen
                scrolling="auto"
              /> */}
            </div>
          </div>
        }
      </div>
    );
  }
}

VideoDialog.propTypes = {
  title: PropTypes.string,
  data: PropTypes.object,
  isFullScreen: PropTypes.bool,
  closeDialog: PropTypes.func,
  clickFullScreen: PropTypes.func
};

export default portalConnect(VideoDialog, {
  key: 'dialog-body-video',
  className: 'dialog-body-video-wrapper'
});
