import React, { Component } from 'react';
import { Scrollbars } from 'amos-framework';
import { utils } from 'amos-tool';
import { PublishContainer, PubHeader, getWsUrl, getScenesAction, getAllPublishsAction } from './amosmorphic';

class Topography extends Component {
  constructor(props) {
    super(props);
    this.state = {
      content: {},
      activeId:''
    };
  }

  componentDidMount() {
    this.loadSketchContent();
  }

  loadSketchContent = () => {
    getAllPublishsAction('2c908ac26ea09873016eb0134c430004').then(data => {
      if (!utils.isEmpty(data)) {
        let content = data[0].publishContent;
        let activeId = data[0].id;
        this.setState({
          content: content,
          activeId:activeId
        });
      }
    });
  }

  calcParams = () => {
    return {
      appId: '2c908ac26ea09873016eb0134c430004',
      id: '',
      token: 'WEB_15_ab637b347a45873c2b60b2c44c614471',
      isPublish: true
    }
  }

  render() {
    const { content, activeId } = this.state;
    return (
      <div className="publish-view">
        <Scrollbars>
          <PublishContainer
            content={content}
            sceneId={activeId}
            paramsInfo={this.calcParams()}
          />
        </Scrollbars>
      </div>
    );
  }
}

export default Topography;