//获取地图上marker详情的偏移位置
//markerPxPosition:当前marker像素点位置
//frameSize:当前地图串口像素点宽高
//infoFrameSize:详情页像素点宽高
export const calcDetailOffset = (markerPxPosition, frameSize, infoFrameSize) => {
  let direction;
  //确认marker在哪个区域内
  if (markerPxPosition.x <= frameSize.width - infoFrameSize.width && markerPxPosition.y <= frameSize.height - infoFrameSize.height) {
    //tip在右下角
    direction = [(infoFrameSize.width / 2 ) - 90, infoFrameSize.height - 115];
  } else if (markerPxPosition.x <= frameSize.width && markerPxPosition.y <= frameSize.height - infoFrameSize.height) {
    //tip在左下角
    direction = [-(infoFrameSize.width / 2) + 100, infoFrameSize.height - 120];
  } else if (markerPxPosition.x <= frameSize.width - infoFrameSize.width && markerPxPosition.y <= frameSize.height) {
    //tip在右上角
    direction = [(infoFrameSize.width / 2) - 70 , -30];
  } else {
    //tip在左上角
    direction = [-(infoFrameSize.width / 2) + 90, -20];
  }
  return direction;
};
