import React, { Component } from 'react';
import { UUID } from 'amos-tool';
import './../../../../styles/view/pamstable/pamstable.scss';
import RouterTab from './routerTab';
import FirewallTab from './firewallTab';


class PamsTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tableContent: []
    };
  }
  componentWillMount(){
    const { data } = this.props;
    let tableContent = [];
    // 2:防火墙;3.交换机;4:暂定为路由器;1:其余,代表负载均衡;
    if ( data.equipType === 1 || data.equipType === 2){
      tableContent = [<FirewallTab></FirewallTab>];
    }else{
      tableContent = [<RouterTab></RouterTab>];
    }
    this.setState({tableContent });
  }

  /**
   *渲染页面
   *
   */
  renderContent = () => {
    const { tableContent } = this.state;
    return tableContent;
  };
  render() {
    return (
      <div className="pams-class" style={{ position: 'absolute',zIndex: '999' }}>
        {this.renderContent()}
      </div>
    );
  }
}

export default PamsTable;
