import React, { Component } from 'react';
import { Pagination } from 'amos-framework';

class PAMSPagination extends Component {
  constructor(props) {
    super(props);
    this.state = {
      totalPage: 0,
      total: 0,
      current: 1,
      pageSize: 2
    };
  }

  /**
   *
   *设置共多少页
   */
  showTotal = total => {
    let totalPage = (total % this.state.pageSize === 0) ? (total / this.state.pageSize) : (total / this.state.pageSize + 1);
    this.setState({ totalPage });
  };

  /**
   * 设置当前页事件
   */
  onPaginationChange = current => {
    this.setState({ current }, this.reload);
  };

  render() {
    const styleA = {
      background: `url('/src/assets/map/person.png')`,
      width: '40px',
      height: '40px',
      lineHeight: '40px',
      display
    };
    return (
      <div>
        <div className="amos-page-power" style={styleA}></div>
        <Pagination
          size="small"
          total={this.state.totals}
          current={this.state.current}
          pageSize='2'
          //onShowSizeChange: this.onSizeChange,
          onChange={this.onPaginationChange}
          showSizeChanger="true"
          showTotal={this.showTotal}
        />
        <div className="page-power" style={styleA}></div>
      </div>
    );
  }
}

export default PAMSPagination;
