import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input,Select } from 'amos-framework';
import FilterPane from './../../../bank/3dview/common/biz/FilterPane';
import { formLayout } from './../../../bank/3dview/common/form/FormUtils';
import './../../3dview/common/form/form.scss';

const FormItem = Form.Item;
const Option = Select.Option;
/**
 * 生产厂家配置页面-筛选面板
 *
 * @class ManufacturerFilter
 * @extends {Component}
 */
class WarningsSearchFilter extends Component {

  static propTypes = {
    pageItem1: PropTypes.object,
    show: PropTypes.bool,
    onFilterChange: PropTypes.func,
    onSearch: PropTypes.func,
    handleFilterShow: PropTypes.func
  };

  static defaultProps = {
    regionList: [],
    stateList: []
  };

  constructor(props) {
    super(props);
    this.state = {
      regionList: [],
      stateList: [],
      alarmLevelData: [
        { name: '全部',value: null },
        { name: '警告告警',value: '警告告警' },
        { name: '次要告警',value: '次要告警' },
        { name: '重要告警',value: '重要告警' },
        { name: '紧急告警',value: '紧急告警' }
      ],
      // alarmSourceTypeData: [
      //   { name: '全部',value: null },
      //   { name: '警告告警',value: '警告告警' },
      //   { name: '监测异常',value: '监测异常' },
      //   { name: 'IP设备告警',value: 'IP设备告警' },
      //   { name: '设备Ping不通',value: '设备Ping不通' },
      //   { name: '监测设备告警',value: '监测设备告警' }
      // ],
      currentStateData: [
        { name: '全部',value: null },
        { name: '清除',value: '清除' },
        { name: '告警',value: '告警' }
      ]
    };
  }
  onChange = (varName, value) => {

    const { onFilterChange, pageItem1 } = this.props;
    for (let i = 0; i < pageItem1.length; i++){
      if (pageItem1[i].name === varName){
        pageItem1[i].value = value;
      }
    }
    onFilterChange(pageItem1);
  }


  render() {
    const { pageItem1, show, onSearch,handleFilterShow } = this.props;
    const { alarmLevelData,currentStateData } = this.state;
    console.log(this.props);
    return (
      <FilterPane show={show} onReset={handleFilterShow} onSearch={onSearch}>
        <Form className="eb-form-tablelist-filter-content"  ref={form => this.form = form} model={pageItem1}>
          <FormItem className={formLayout('100', '100')}  label={<span>告警源IP</span>} field="alarmSourceIp">
            <Input  onChange={(e) => this.onChange('alarmSourceIp', e.target.value)} />
          </FormItem>
          <FormItem className={formLayout('100', '100')}  label={<span>告警源名称</span>} field="alarmSourceName">
            <Input  onChange={(e) => this.onChange('alarmSourceName', e.target.value)} />
          </FormItem>
          <FormItem className={formLayout('100', '100')}  label={<span>严重度</span>}>
            <Select  onChange={(value)=> this.onChange('alarmLevel', value)}>
              {alarmLevelData.map(item => {
                return (
                  <Option key={item.value} value={item.value}>{item.name}</Option>
                );
              })}
            </Select>
          </FormItem>
          <FormItem className={formLayout('100', '100')}  label={<span>当前状态</span>} field="currentState">
            <Select  onChange={(value)=> this.onChange('currentState', value)}>
              {currentStateData.map(item => {
                return (
                  <Option key={item.value} value={item.value}>{item.name}</Option>
                );
              })}
            </Select>
          </FormItem>
          <FormItem className={formLayout('100', '100')}  label={<span>告警类别</span>} field="alarmSourceType">
            <Input  onChange={(e) => this.onChange('alarmSourceType', e.target.value)} />
          </FormItem>
        </Form>
      </FilterPane>
    );
  }

}

export default WarningsSearchFilter;
