import React, { Component } from 'react';
import moment from 'moment';
import PropTypes from 'prop-types';
import CheckTable from './CheckTable';
import CheckSearch from './CheckSearch';
import { queryCheckInfoAction } from '../../../services/patrolService';
import SplitterLayout from '../../common/side/SideQueryLayout';

/**
 * 巡检记录
 *
 * @class Check
 * @extends {Component}
 */
class Check extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      statisticsData: [],
      totalCount: 0,
      planId: '',
      showQuery: false,
      pointNo: ''
    };
  }

  componentWillMount() {
    let { searchParam } = this.state;
    const { pointId } = (this.props.location || {}).state || {};
    let beginToday = moment(new Date()).format('YYYY-MM-DD') + ' 00:00:00';
    let endToday = moment(new Date()).format('YYYY-MM-DD') + ' 23:59:59';
    searchParam.push({ name: 'beginDate', value: beginToday });
    searchParam.push({ name: 'endDate', value: endToday });
    if (pointId) {
      searchParam = searchParam.filter(item => item.name !== 'pointId');
      searchParam.push({ name: 'pointId', value: pointId });
      this.setState({ pointId });
    }
    this.setState({ searchParam });
  }

  componentWillReceiveProps = (nextProps) => {
    const { pointId } = (nextProps.location || {}).state || {};
    let { searchParam } = this.state;
    if (pointId) {
      searchParam = searchParam.filter(item => item.name !== 'pointId');
      searchParam.push({ name: 'pointId', value: pointId });
      this.setState({ searchParam,  pointId },()=>this.questStatistiscData({ pageNumber: 0, pageSize: 10 }));
    }
  };

  onSearchDataSyn = (queryParam, param) => {
    let quest = [];
    if (queryParam) {
      for (let key in queryParam) {
        let obj = queryParam[key];
        quest.push(obj);
      }
    }
    this.setState({ searchParam: quest }, () => {
      this.questStatistiscData(param);
    });
  };

  questStatistiscData = param => {
    let { searchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    this.queryCheckInfo(searchParam, pageNumber, pageSize);
  };

  queryCheckInfo(searchParam, pageNumber, pageSize) {
    queryCheckInfoAction(searchParam, pageNumber, pageSize).then(data => {
      let statisticsData = data.content;
      let totalCount = data.totalElements;
      this.setState({
        statisticsData,
        totalCount
      });
    });
  }

  changeStatus = (open) => {
    this.setState({ showQuery: open });
  }

  loopChangeStatus = (open) => {
    const { showQuery } = this.state;
    showQuery ? this.setState({ showQuery: false }) : this.setState({ showQuery: true });
  }

  render() {
    let { statisticsData, totalCount, planId, pointNo, searchParam,showQuery } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout open={showQuery} callback={this.changeStatus}>
          <CheckSearch search={this.onSearchDataSyn} planId={planId} pointNo={pointNo} />
        </SplitterLayout>
        <CheckTable tableState={this.state} count={totalCount} fetchData={this.questStatistiscData} searchParam={searchParam} changeStatus={this.loopChangeStatus} dataList={statisticsData} planId={planId} />
      </div>
    );
  }
}

Check.propTypes = {
  location: PropTypes.object
};

export default Check;
