import React, { Component } from 'react'; import PropTypes from 'prop-types';
import './searchbtn.scss';

class SearchBtn extends Component {
  constructor(props) {
    super(props);
    this.state = {
      click: true
    };
  }

  handleClick = () => {
    this.props.onclick();
    let upOrDown = !this.state.click;
    this.setState({ click: upOrDown });
  }

  render() {
    let { upText,downText,img } = this.props;
    let text = this.state.click ? downText : upText;
    let imgClass = this.state.click ? 'img-down' : 'img-up';
    return (
      <div className='search-upordown-btn' onClick={this.handleClick} >
        <span className=''>{text}</span>
        <img className={imgClass} src={img} alt='' />
      </div>
    );
  }
}

SearchBtn.propTypes = {
  onclick: PropTypes.func,
  upText: PropTypes.string,
  downText: PropTypes.string,
  img: PropTypes.string
};

SearchBtn.defaultProps = {
  upText: '收起搜索',
  downText: '展开搜索',
  img: require('./../../../../../assets/fsc/img/search_btnbg.png')
};

export default SearchBtn;
