import React, { Component } from 'react';
import { Form, Input, Select, Radio } from 'amos-framework';
import moment from 'moment';
import PropTypes from 'amos-react-router/lib/PropTypes';
import { queryDeptByOrgCodeAction } from '../../../../../services/preControlService';

const FormItem = Form.Item;
const Option = Select.Option;
const RadioGroup  = Radio.Group;
const TextArea = Input.TextArea;

const floorData = [{ id: '1', name: '1层' }, { id: '2', name: '2层' }, { id: '3', name: '3层' }, { id: '4', name: '4层' }, { id: '5', name: '5层' }];

/**
 * 消防车新增及编辑
 */
class FireTruckModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      form: {
        name: '',
        carNum: '',
        country: '',
        engineNum: '',
        deptId: -1,
        model: '',
        state: '',
        type: '',
        floor3d: '1',
        position3d: '',
        remark: '',
        isIndoor: true
      },
      chargeDeptData: [],
      rules: {
        carNum: [{ required: true, message: '车牌号不能为空' }],
        name: [{ required: true, message: '名称不能为空' }],
        position3d: [{ validator: this.validPositon3d }]
      }
    };
  }

  componentWillMount = () => {
    queryDeptByOrgCodeAction().then(
      data => {
        this.setState({ chargeDeptData: data });
      }
    );
  };


  onInputChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
    this.props.updateFireCarState(key, value);
  };

  onSelectChange(key, value) {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
    this.props.updateFireCarState(key, value);
  }

  validPositon3d = (rule, value, callback) => {
    let tempArry = value.split(',') || [];
    if ( tempArry && tempArry.length === 3 ){
      const patt = /(^([-]?)[1-9]([0-9]+)?(\.[0-9]+)?$)|(^([-]?)(0){1}$)|(^([-]?)[0-9]\.[0-9]+?$)/;
      let i = 0;
      for (let key of tempArry){
        if (!patt.test(key)){
          i = i + 1;
          callback('非法格式');
          break;
        }
      }
      i === 0 ? callback() : '';
    } else if (!value) {
      callback();
    } else {
      callback('非法格式');
    }
  }

  render() {
    const { form, rules, chargeDeptData } = this.state;
    const { truckInfo } = this.props || {};
    truckInfo && Object.assign(form,truckInfo);
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <div>
        <Form model={form} rules={rules} ref={component => this.form = component}>
          <div className='important-equipment-edit'>
            <FormItem label={<span>车辆名称</span>} field="name" {...formItemLayout}>
              <Input className="risk_factor_input" required value={form.name} onChange={e => this.onInputChange('name', e.target.value)} />
            </FormItem>
            <FormItem label={<span>部门</span>} field="deptId" {...formItemLayout}>
              <Select
                className="risk_factor_select"
                data={chargeDeptData}
                renderOption={item => <Option value={parseInt(item.id)}>{item.departmentName}</Option>}
                defaultOption={<Option value={-1}>{'请选择'}</Option>}
                value={form.deptId}
                onChange={e => this.onSelectChange('deptId', e)}
              />
            </FormItem>
            <FormItem label={<span>发动机号</span>} field="engineNum" {...formItemLayout}>
              <Input className="risk_factor_input" required value={form.engineNum} onChange={e => this.onInputChange('engineNum', e.target.value)} />
            </FormItem>
            <FormItem label={<span>车辆状态</span>} field="state" {...formItemLayout}>
              <Input className="risk_factor_input" required value={form.state} onChange={e => this.onInputChange('state', e.target.value)} />
            </FormItem>
            <FormItem label={<span>3维坐标</span>} field="position3d" {...formItemLayout}>
              <Input className="risk_factor_input" required value={form.position3d} onChange={e => this.onInputChange('position3d', e.target.value)} />
            </FormItem>
            <FormItem label={<span>3维楼层</span>} field="floor3d" {...formItemLayout}>
              <Select
                className="fire-equip-select"
                data={floorData}
                defaultValue='1'
                value={form.floor3d}
                renderOption={item => <Option value={item.id}>{item.name}</Option>}
                onChange={e => this.onInputChange('floor3d', e)}
              />
            </FormItem>
            <FormItem label={<span>是否室内</span>} field="isIndoor" {...formItemLayout}>
              <RadioGroup defaultValue={form.isIndoor} value={form.isIndoor}  onChange={e => this.onInputChange('isIndoor', e)}>
                <Radio value={false}>否</Radio>
                <Radio value={true}>是</Radio>
              </RadioGroup>
            </FormItem>
            <FormItem label={<span>车牌号</span>} field="carNum" {...formItemLayout}>
              <Input className="risk_factor_input" required value={form.carNum} onChange={e => this.onInputChange('carNum', e.target.value)} />
            </FormItem>
            <FormItem label={<span>车辆类别</span>} field="type" {...formItemLayout}>
              <Input className="risk_factor_input" required value={form.type} onChange={e => this.onInputChange('type', e.target.value)} />
            </FormItem>
            <FormItem label={<span>厂牌型号</span>} field="model" {...formItemLayout}>
              <Input className="risk_factor_input" required value={form.model} onChange={e => this.onInputChange('model', e.target.value)} />
            </FormItem>
            <FormItem label={<span>国别</span>} field="country" {...formItemLayout}>
              <Input className="risk_factor_input" required value={form.country} onChange={e => this.onInputChange('country', e.target.value)} />
            </FormItem>
            <FormItem label={<span>备注</span>} field="remark" {...formItemLayout}>
              <TextArea rows={10} cols={20} className="risk_factor_input" required value={form.remark} onChange={e => this.onInputChange('remark', e.target.value)} />
            </FormItem>
          </div>
        </Form>
      </div>
    );
  }
}

FireTruckModel.propTypes = {
  equipmentId: PropTypes.number,
};
export default FireTruckModel;
