import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input, Select, Radio } from 'amos-framework';
import { stringify } from 'amos-tool';

import { getFireStationDetailAction } from '../../../../../services/ledgerService';

const FormItem = Form.Item;
const RadioGroup = Radio.Group;
const Option = Select.Option;
const floorData = [{ id: '1', name: '1层' }, { id: '2', name: '2层' }, { id: '3', name: '3层' }, { id: '4', name: '4层' }, { id: '5', name: '5层' }];

class FireFoamDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      station: {
        name: '',
        code: '',
        address: '',
        position3d: '',
        floor3d: '',
        isIndoor: true
      }
    };
  }
  componentDidMount() {
    this.queryFireStationDetail();
  }

  queryFireStationDetail = () => {
    let { stationId } = this.props;
    getFireStationDetailAction(stationId).then(station => {
      this.setState({ station });
    });
  };

  render() {
    const { station } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <Form className="basic-demo" model={station}>
        <FormItem label={<span>泡沫间名称</span>} field="name" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.name} />
        </FormItem>
        <FormItem label={<span>泡沫间编码</span>} field="code" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.code} />
        </FormItem>
        <FormItem label="泡沫间地址" field="address" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.address} />
        </FormItem>
        <FormItem label={<span>3维坐标</span>} field="position3d" {...formItemLayout}>
          <Input className="risk_factor_input"  value={station.position3d} />
        </FormItem>
        <FormItem label={<span>3维楼层</span>} field="floor3d" {...formItemLayout}>
          <Select className="risk_factor_input"  data={floorData} value={station.floor3d} renderOption={item => <Option value={item.id}>{item.name}</Option>} />
        </FormItem>
        <FormItem label={<span>是否室内</span>} field="isIndoor" {...formItemLayout}>
          <RadioGroup defaultValue={station.isIndoor} className="risk_factor_input" value={station.isIndoor}>
            <Radio value={false}>否</Radio>
            <Radio value={true}>是</Radio>
          </RadioGroup>
        </FormItem>
      </Form>
    );
  }
}

FireFoamDetail.propTypes = {
  stationId: PropTypes.number
};
export default FireFoamDetail;
