import React, { Component } from 'react';
import { Tabs } from 'amos-antd';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import FireFoamable from './fireFoam';

const TabPane = Tabs.TabPane;

class FireStationView extends Component {
  constructor(props) {
    super(props);

    this.state = {
      oparate: 0
    };
  }

  componentWillReceiveProps = (nextProps) => {
    this.setState({ oparate: 0 });
  }

  onTabClick = key => {
    let searchParam = {};
    searchParam.pageNumber = 0;
    searchParam.pageSize = 10;
    if (key === '1') {
      this.getFireWaterData(searchParam);
    }
    this.setState({ activeKey: key });
  };


  addWaterResource = () => {
    this.setState({ oparate: 1 });
  }

  editWaterResource = () => {
    this.setState({ oparate: 2 });
  }

  deleteWaterResource = () => {
    this.setState({ oparate: 3 });
  }

  render() {
    let { oparate } = this.state;
    const extra = [
      <Button key="add" transparent icon="add" onClick={this.addWaterResource} />,
      <Button key="edit" transparent icon="edit" onClick={this.editWaterResource} />,
      <Button key="del" transparent icon="delete" onClick={this.deleteWaterResource} />
    ];
    return (
      <div className="convertor-fire-resource" style={{ background: '#33333', height: '100%' }}>
        <FireFoamable oprType={oparate} />
        <Tabs defaultActiveKey="1" onTabClick={this.onTabClick} type="card" tabBarExtraContent={extra} >
          <TabPane tab='消防泡沫间' key='1'>
            <FireFoamable oprType={oparate} />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}

FireStationView.propTypes = {

};
export default FireStationView;
