import { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect } from 'amos-framework';
import { browserHistory } from 'amos-react-router';
import { Store } from 'amos-tool';
import storageConsts, { CONSTS } from './../../consts/storageConsts';
import { pathMapping } from './../../routes/customRoutes';

const enhanceStorage = Connect.enhanceStorage;
const lsTool = Store.lsTool;

/**
 * 业务视图
 *
 * @class BusinessView
 * @extends {Component}
 */

@enhanceStorage({
  storageItems: storageConsts(CONSTS)
})
class BusinessStorage extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  onStorageChange = (data, e) => {
    const controlData = this.props.read(CONSTS.control);
    controlData && this.handleControlData(JSON.parse(controlData));
    const forwardData = this.props.read(CONSTS.forward);
    console.log('======================>', forwardData);
    forwardData && this.handleForwardData(JSON.parse(forwardData));
    const sideControlData = this.props.read('sideControl');
    console.log('安岸》', sideControlData);
    sideControlData && this.handleSideControlData(JSON.parse(sideControlData));

    const changeRegionData = this.props.read(CONSTS.region_change);
    changeRegionData && this.handleChangeRegionData(JSON.parse(changeRegionData));
  }

  handleControlData = (controlData) => {
    //处理三维视图中设置菜单中的注销同时关闭业务视图
    if (controlData.control) {
      const { logOut } = controlData.control || {};
      if (logOut) {
        window.localStorage.removeItem('cityLine');
        window.close();
      }
    }
  }
  /**
   * 处理三维地图上各种点的跳转
   */
  handleForwardData = (forwardData) => {
    //处理三维视图中设置菜单中的注销同时关闭业务视图
    if (forwardData.details) {
      const { dialogId, type, detailForw, checkId } = forwardData.details || {};
      if (type === 'patrol') {
        return;
      } else if (type === 'risk') {
        if (detailForw === 'details'){
          browserHistory.push({ pathname: pathMapping.pointInfo, state: { pointDetail: { pointID: dialogId } } });
        } else if (detailForw === 'danger'){
          const { name } = forwardData.details || {};
          browserHistory.push({ pathname: pathMapping.dangerList, state: { point: { id: dialogId, name, normalForward: false } } });
        } else if (detailForw === 'record'){
          browserHistory.push({ pathname: pathMapping.pointCheckDetail, state: { pointID: dialogId,checkID: checkId } });
        }
      } else if (type === 'video') { 
        return;
      } else if (type === 'person') {
        return;
      } else if (type === 'data') {
        return;
      } else if (type === 'croom') {
        return;
      } else if (type === 'riskSource') {//风险模型
        browserHistory.push({ pathname: pathMapping.riskModel, state: { riskSourceId: dialogId }});
      }else if (type === 'impEquipment') {//重点装备
        browserHistory.push({ pathname: pathMapping.matchEquipment, state: { equipmentId: dialogId }});
      }else if (type === 'fireResource') {//消防资源
        if (detailForw === 'fireCar'){//消防车
          browserHistory.push({ pathname: pathMapping.firetruckinfo, state: { fireCarId: dialogId }});
        }
      }
    }
  }

  handleSideControlData = (data) => {

  }

  handleChangeRegionData = (changeRegionData) => {
    if (changeRegionData.refresh) {
      const { refresh } = changeRegionData.refresh || {};
      if (refresh) {
        if (window && !window.closed) {
          //window.localStorage.removeItem(CONSTS.region_change);
          lsTool.remove(CONSTS.region_change);
          window.location.reload(true);
        }
      }
    }
  }

  render() {
    return null;
  }
}

BusinessStorage.propTypes = {
  read: PropTypes.func
};

export default BusinessStorage;
