import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { browserHistory } from 'amos-react-router';
import { Button, Layout } from 'amos-framework';
import BizIcon from './../../common/icon/BizIcon';

const { Header, Footer, Sider, Content } = Layout;

class DifferentiateDetial extends Component {
  constructor(props) {
    super(props);
  }

  getDetailInfo(differObj) {
    let { name, username, time, status, range } = differObj;
    let color = status === '合格' ? '#33cc33' : '#ff0000';
    return (
      <div>
        <div className='info-line1'>
          <div className='col1'>
            <div className='info-title'>
              巡检点：
            </div>
            <div className='info-value'>
              {name}
            </div>
          </div>
          <div className='col2'>
            <div className='info-title'>
              责任人：
            </div>
            <div className='info-value'>
              {username}
            </div>
          </div>
        </div>
        <div className='info-line2'>
          <div className='info-title'>
            时间：
          </div>
          <div className='info-value'>
            {time}
          </div>
        </div>
        <div className='info-line1'>
          <div className='col1'>
            <div className='info-title'>
              标准区间：
            </div>
            <div className='info-value'>
              {range}
            </div>
          </div>
          <div className='col2'>
            <div className='info-title'>
              判别结果：
            </div>
            <div className='info-value' style={{ color }}>
              {status}
            </div>
          </div>
        </div>
      </div>
    );
  }

  goBack() {
    browserHistory.goBack();
  }

  render() {
    let differObj = {};
    if (this.props.location && this.props.location.state) {
      differObj = this.props.location.state.differObj;
    }
    let rimgPath = differObj['r-img'];
    let simgPath = differObj['s-img'];
    return (
      <Layout className='differentiate-layout'>
        <Header className='differentiate-header'>
          <div className='match-equipment-toolbar-goback'>
            <Button icon={<BizIcon icon="fanhui" />} transparent onClick={() => this.goBack()}  />
          </div>
        </Header>
        <Layout>
          <Sider className='differentiate-sider'>
            <div className='differentiate-photoes-r'>
              <div className='title'>现场图片</div>
              <div className='img'>
                <img alt='现场图片' src={rimgPath} />
              </div>
            </div>
          </Sider>
          <Content className='differentiate-content'>
            <div className='differentiate-photoes-s'>
              <div className='title'>标准图片</div>
              <div className='img'>
                <img alt='现场图片' src={simgPath} />
              </div>
            </div>
          </Content>
        </Layout>
        <Footer className='differentiate-footer'>
          <div className='differentiate-info'>
            {this.getDetailInfo(differObj)}
          </div>
        </Footer>
      </Layout>
    );
  }
}
DifferentiateDetial.propTypes = {
  differObj: PropTypes.object
};
export default DifferentiateDetial;
