import React, { Component } from 'react';
import moment from 'moment';
import { browserHistory } from 'amos-react-router';
import AmosGridTable from './../common/tableComponent/table/AmosGridTable';
import DifferentiateSearch from './DifferentiateSearch';
import { pathMapping } from './../../../routes/customRoutes';
import data from './data.json';

const differentiateDetailPath = pathMapping.differentiateDetail;

const getColumns = (self) => {
  return [
    {
      title: '序号',
      render: (text, record, index) => `${index + 1}`
    },
    {
      title: '巡检点编号',
      dataIndex: 'code',
      key: 'code',
      width: '10%',
      className: 'uant-table-thead'
    },
    {
      title: '巡检点',
      dataIndex: 'name',
      key: 'name',
      width: '15%',
      className: 'uant-table-thead'
    },
    {
      title: '责任人',
      dataIndex: 'username',
      key: 'username',
      width: '8%',
      className: 'uant-table-thead'
    },
    {
      title: '时间',
      dataIndex: 'time',
      key: 'time',
      width: '10%',
      render: text => moment(text).format('YYYY-MM-DD HH:mm:ss'),
      className: 'uant-table-thead'
    },
    {
      title: '标准区间',
      dataIndex: 'range',
      key: 'range',
      width: '8%',
      className: 'uant-table-thead'
    },
    {
      title: '实际值',
      dataIndex: 'value',
      key: 'value',
      width: '8%',
      className: 'uant-table-thead'
    },
    {
      title: '标准图片',
      dataIndex: 's-img',
      key: 's-img',
      width: '10%',
      className: 'uant-table-thead',
      render: text => {
        return <img alt='标准图片' src={text} width='50' height='50' />;
      }
    },
    {
      title: '现场图片',
      dataIndex: 'r-img',
      key: 'r-img',
      width: '10%',
      render: text => {
        return <img alt='现场图片' src={text} width='50' height='50' />;
      }
    },
    {
      title: '判别结果',
      dataIndex: 'status',
      key: 'status',
      width: '10%',
      render: text => {
        if (text === '合格') {
          return <span style={{ color: '#33cc33' }}>{text}</span>;
        } else {
          return <span style={{ color: '#ff0000' }}>{text}</span>;
        }
      }
    },
    {
      title: '操作',
      dataIndex: 'created_time',
      key: 'created_time',
      width: '8%',
      render: (text, record, index) => {
        return (
          <span>
            <a href="javascript:;" onClick={() => {self.onDetailClick(record);}}>详情查看</a>
          </span>
        );
      }
    }
  ];
};

/**
 * 智能判别页面视图
 */
class DifferentiateView extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 0,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: false,
      selectedRows: [],
      selectedRowKeys: [],
      searchParam: [],
      allDataList: [],
      dataList: [],
      totalCount: 0
    };
  }

  componentDidMount() {
    this.getDataFromJson();
  }

  onDetailClick = record => {
    let path = {
      pathname: differentiateDetailPath,
      state: { differObj: record }
    };
    browserHistory.push(path);
  };

  /**
   * 分页设置参数
   */
  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  };

  setSearchParam = searchParam => {
    // let paramArry = new Array();
    // for (let key in searchParam) {
    //   paramArry.push({ name: key, value: searchParam[key] });
    // }
    this.setState({ searchParam }, () => this.questDifferentiateData({ pageNumber: this.pageConfig.current - 1, pageSize: this.pageConfig.pageSize }));
  };

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  getDataFromJson = () => {
    this.setState({
      allDataList: data.dataList,
      dataList: data.dataList,
      totalCount: data.dataList.length
    });
  }

  questDifferentiateData = param => {
    let { searchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    this.queryDifferentiateList(searchParam, pageNumber, pageSize);
  };

  queryDifferentiateList = (searchParam, pageNumber, pageSize) => {
    let { dataList, allDataList } = this.state;
    dataList = [...allDataList];
    if (searchParam.status && searchParam.status !== '全部') {
      dataList = dataList.filter(item => item.status === searchParam.status);
    }
    if (searchParam.endTime) {
      let startTime = new Date(searchParam.startTime).getTime();
      let endTime = new Date(searchParam.endTime).getTime();
      dataList = dataList.filter(item => {
        let _time = new Date(item.time).getTime();
        return _time >= startTime && _time <= endTime;
      });
    }
    if (searchParam.username) {
      dataList = dataList.filter(item => item.username.indexOf(searchParam.username) > -1);
    }
    if (searchParam.name) {
      dataList = dataList.filter(item => item.name.indexOf(searchParam.name) > -1);
    }
    this.setState({
      dataList,
      pageNumber,
      pageSize,
      totalCount: dataList.length
    });
  };

  render() {
    let { pagination, isChecked, dataList, totalCount, selectedRowKeys } = this.state;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="alarm-view differentiate-view">
        <DifferentiateSearch setSearchParam={this.setSearchParam} />
        <AmosGridTable
          columns={getColumns(this)}
          callBack={this.reload}
          isPageable={pagination}
          dataList={dataList}
          totals={totalCount}
          getTableDataAction={this.questDifferentiateData}
          selectedRowKeys={selectedRowKeys}
          getSelectedRows={this.getSelectedRows}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          onRowDoubleClick={this.onRowDoubleClick}
          isChecked={isChecked}
        />
      </div>
    );
  }
}

DifferentiateView.propTypes = {};
export default DifferentiateView;
