import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Tree } from 'amos-antd';

const TreeNode = Tree.TreeNode;

class TreeComponent extends Component {

  renderTreeNodes = (data) => {
    return data.map((item) => {
      if (item.children && item.children.length) {
        return (
          <TreeNode title={item.name} key={item.id} parent={item.parent} >
            {this.renderTreeNodes(item.children)}
          </TreeNode>
        );
      }
      return (<TreeNode title={item.name} key={item.id} parent={item.parent} />);
    });
  }

  render() {
    const { className,treeData,expandedKeys,selectedKeys,autoExpandParent,onSelect,onExpand } = this.props;
    return (
      <div className={classnames('tree-wrapper', className)}>
        <Tree
          selectedKeys={selectedKeys}
          expandedKeys={expandedKeys}
          onSelect={onSelect}
          onExpand={onExpand}
          autoExpandParent={autoExpandParent}
        >
          {this.renderTreeNodes(treeData)}
        </Tree>
      </div>
    );
  }
}

TreeComponent.propTypes = {
  className: PropTypes.string,
  treeData: PropTypes.object,
  selectedKeys: PropTypes.array,
  expandedKeys: PropTypes.array,
  autoExpandParent: PropTypes.bool,
  onSelect: PropTypes.func,
  onExpand: PropTypes.func
};

export default TreeComponent;
