import React, { Component } from 'react'; import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import AmosGridTable from './../common/tableComponent/table/AmosGridTable';
import { fetchXJChkExecuteAction } from './../../../services/checkInfoService';
import moment from 'moment';
const finishStatusEnum = {'0':'进行中','1':'未开始','2':'已结束','3':'已超时'};
const xjColumns = (actions) => {
  return [
    {
      title: '巡检计划名称',
      dataIndex: 'name',
      key: 'name',
      width: '20%'
    },{
      title: '开始时间',
      dataIndex: 'lastTime',
      key: 'lastTime',
      width: '20%'
    },{
      title: '结束时间',
      dataIndex: 'endTime',
      key: 'endTime',
      width: '20%'
    },{
      title: '完成情况',
      dataIndex: 'finishStatus',
      key: 'finishStatus',
      width: '12%',
      render: (text) => finishStatusEnum[text]
    },{
      title: '巡检人员',
      dataIndex: 'realName',
      key: 'realName',
      width: '13%'
    },{
      title: '联系方式',
      dataIndex: 'loginName',
      key: 'loginName',
      width: '15%'
    }
  ];
};
/**
 * 巡检执行情况
 * @class ExecutionSituation
 * @extends {Component}
 */
class ExecutionSituation extends Component{
    constructor(props) {
        super(props);
        this.pageConfig = {
        current: props.outterPageConfig ? props.outterPageConfig.current : 1,
        pageSize: props.outterPageConfig ? props.outterPageConfig.pageSize : 5
        };
        this.state = {
        selectedRows: [],
        selectedRowKeys: [],
        searchParam: {},
        dataList: [],
        totalCount: 0,
        reload(){}
        };
      }
   /**
   * 获取表格刷新方法
   */
  reload = (r) => {
    this.setState({ reload: ()=>{r();this.setState({ selectedRows: [],selectedRowKeys: [] });} },r());
  }
  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  }
    componentWillMount() {
    }

    componentDidMount(){
    }

    componentWillReceiveProps(nextProps) {

    }

    componentWillUnmount() {
    }
  
   getStatistiscData = param => {
    let { searchParam } = this.state;
    // searchParam.checkDate ='20181123';
    searchParam.checkDate =  moment().format('YYYYMMDD');//当前时间查询无记录，测试用固定日期，后期需注释掉上行，放开本行
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    Object.assign(searchParam, { ...param });
    fetchXJChkExecuteAction(searchParam).then(data => {
      let statisticsData = data.content;
      let totalCount = data.totalElements;
      this.setState({
        dataList: statisticsData,
        totalCount: totalCount
      });
    });
  };
    render() {
        let { dataList,totalCount } = this.state;
        let { reload } = this.state;
        let defaultPageConfig = this.pageConfig;
        let pageConfig = this.pageConfig;
        const actions = {};
        const pagination = {pageSizeOptions:['5'],defaultPageSize:5};//分页：5条每页，默认为5
        return (
        <div className='point-execution-situation'>
            <div className="point-execution-situation-title">今日执行情况</div>
           <div className='point-list-content'>
                <AmosGridTable
                columns={xjColumns(actions)}
                callBack={this.reload}
                dataList={dataList}
                isChecked={false}
                totals={totalCount}
                pagination={pagination}
                getTableDataAction={this.getStatistiscData}
                getSelectedRows={this.getSelectedRows}
                rowClassName={this.getRowClassName}
                setPageConfig={this.setPageConfig}
                defaultPageConfig={defaultPageConfig}
                getPanelHeight={this.getPanelHeight}
                /> 
            </div>   
        </div>
        );
    }
}

ExecutionSituation.propTypes = {
   
  };
  
  ExecutionSituation.defaultProps = {
    data: {},
    legend: [],
    chartStyle: { width: '100%',height: '20rem' }
  };
  
  export default ExecutionSituation;