import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { TreeSelect } from 'amos-antd';
import { Input, Form, Button, Select } from 'amos-framework';
import {} from './../../../../../services/bizService';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 *
 * 设备设施危险源
 * @class EquipRiskSourceListSearch
 * @extends {Component}
 */
class EquipRiskSourceListSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        equipmentCode: {
          name: 'equipmentCode',
          type: 'LIKE',
          value: ''
        },
        equipmentName: {
          name: 'equipmentName',
          type: 'LIKE',
          value: ''
        },
        workshopSection: {
          name: 'workshopSection',
          type: 'LIKE',
          value: ''
        },
        departmentId: {
          name: 'departmentId',
          type: 'EQUAL',
          value: ''
        },
        regionId: {
          name: 'regionId',
          type: 'EQUAL',
          value: ''
        },
        riskLevel: {
          name: 'riskLevel',
          type: 'EQUAL',
          value: ''
        },
        identificationMethodId: {
          name: 'identificationMethodId',
          type: 'EQUAL',
          value: ''
        },
        identificationUserId: {
          name: 'identificationUserId',
          type: 'EQUAL',
          value: ''
        }
      },
      deptData: [],
      areaData: [],
      levelData: []
    };
  }

  componentWillMount() {

  }

  componentDidMount() {

  }

  onInputChange =(key,value)=>{
    const { form } = this.state;
    if (key === 'regionId') {
      form['departmentId'].value = '';
      this.getDeptData(value);
    }
    form[key].value = value;
    this.setState({ form });
  }

  onClick =()=>{
    const { form } = this.state;
    this.props.search(form);
  }

  onSelectChange = (key, value, t, obj) => {
    const { form } = this.state;
    if (obj && obj.triggerNode && obj.triggerNode.props && obj.triggerNode.props.type === 'department') {
      return;
    }
    if (obj && obj.triggerNode && obj.triggerNode.props && obj.triggerNode.props.type === 'model') {
      return;
    }
    form[key].value = value;
    this.setState({ form });
  };

  getDeptData = (regionId) => {
    let { deptData } = this.state;
    const { searchCommonData } = this.props;
    let depatData = searchCommonData.regionDepartmentTree && searchCommonData.regionDepartmentTree.secondDepartments;
    let dData  = new Map(Object.entries(depatData)).get(String(regionId));
    deptData = [];
    dData && dData.map(item => {
      let deptObj = {};
      deptObj.id = item.sequenceNbr;
      deptObj.name = item.departmentName;
      deptData.push(deptObj);
    });
    this.setState({ deptData });
  };

  initFormValues =()=>{
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  }

  render() {
    let { form, deptData, areaData, levelData } = this.state;
    const { searchCommonData } = this.props;
    levelData = searchCommonData && searchCommonData.riskLevelData;
    areaData = searchCommonData && searchCommonData.regionData;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 10 }
      }
    };
    return (
      <Form className="risk-list-search" model={form}>
        <FormItem label={<span>危险源名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="risk-list-input" onChange={e => this.onInputChange('name', e.target.value)} />
        </FormItem>
        <FormItem label={<span>设备位号</span>} field="equipmentCode" {...formItemLayout}>
          <Input value={form.equipmentCode.value} className="risk-list-input" onChange={e => this.onInputChange('equipmentCode', e.target.value)} />
        </FormItem>
        <FormItem label={<span>设备名称</span>} field="equipmentName" {...formItemLayout}>
          <Input value={form.equipmentName.value} className="risk-list-input" onChange={e => this.onInputChange('equipmentName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>所属工段</span>} field="workshopSection" {...formItemLayout}>
          <Input value={form.workshopSection.value} className="risk-list-input" onChange={e => this.onInputChange('workshopSection', e.target.value)} />
        </FormItem>
        <FormItem label={<span>所在分区</span>} field="regionId" {...formItemLayout}>
          <Select
            className="risk-list-select"
            data={areaData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.regionId.value}
            onChange={value => this.onInputChange('regionId', value)}
          />
        </FormItem>
        <FormItem label={<span>部门/车间</span>} field="departmentId" {...formItemLayout}>
          <Select
            className="risk-list-select"
            data={deptData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.departmentId.value}
            onChange={value => this.onInputChange('departmentId', value)}
          />
        </FormItem>
        <FormItem label={<span>风险等级</span>} field="riskLevel" {...formItemLayout}>
          <TreeSelect
            value={form.riskLevel.value === 0 ? undefined : form.riskLevel.value}
            className="risk-list-select"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={levelData || []}
            placeholder="请选择"
            allowClear
            showSearch
            treeNodeFilterProp={'title'}
            treeDefaultExpandAll
            onChange={(e, t, obj) => this.onSelectChange('riskLevel', e, t, obj)}
          />
        </FormItem>
        <FormItem label={<span>辨识方法</span>} field="identificationMethodId" {...formItemLayout}>
          <Select
            className="risk-model-select"
            data={searchCommonData.methodData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            values={form.identificationMethodId.value}
            onChange={value => this.onSelectChange('identificationMethodId', value)}
          />
        </FormItem>
        <FormItem label={<span>辨识人</span>} field="identificationUserId" {...formItemLayout}>
          <TreeSelect
            value={form.identificationUserId.value === 0 ? undefined : form.identificationUserId.value}
            className="risk-list-select"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={searchCommonData.userData || []}
            placeholder="请选择"
            allowClear
            treeDefaultExpandAll
            showSearch
            treeNodeFilterProp={'title'}
            onChange={(e, t, obj) => this.onSelectChange('identificationUserId', e, t, obj)}
          />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick}className='risk-list-search-button' >查询</Button>
        </FormItem>
      </Form>
    );
  }
}

EquipRiskSourceListSearch.propTypes = {
  search: PropTypes.func,
  searchCommonData: PropTypes.object
};

export default EquipRiskSourceListSearch;
