import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { TreeSelect } from 'amos-antd';
import { Input, Form, Button } from 'amos-framework';

const FormItem = Form.Item;

class MajorHazardsListSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        riskSourceName: {
          name: 'riskSourceName',
          type: 'LIKE',
          value: ''
        },
        riskLevel: {
          name: 'riskLevel',
          type: 'EQUAL',
          value: ''
        }
      }
    };
  }

  componentDidMount() {

  }

  onInputChange =(key,value)=>{
    const { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  }

  onClick =()=>{
    const { form } = this.state;
    this.props.search(form);
  }

  onSelectChange = (key, value, t, obj) => {
    const { form } = this.state;
    if (obj && obj.triggerNode && obj.triggerNode.props && obj.triggerNode.props.type === 'model') {
      return;
    }
    form[key].value = value;
    this.setState({ form });
  };

  initFormValues =()=>{
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  }

  render() {
    const { form } = this.state;
    const { searchCommonData } = this.props;
    let { riskLevelData } = searchCommonData || {};
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 10 }
      }
    };
    return (
      <Form className="risk-list-search" model={form}>
        <FormItem label={<span>重大危险源名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="risk-list-input" onChange={e => this.onInputChange('name', e.target.value)} />
        </FormItem>
        <FormItem label={<span>风险区域名称</span>} field="riskSourceName" {...formItemLayout}>
          <Input value={form.riskSourceName.value} className="risk-list-input" onChange={e => this.onInputChange('riskSourceName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>级别</span>} field="riskLevel" {...formItemLayout}>
          <TreeSelect
            value={form.riskLevel.value === 0 ? undefined : form.riskLevel.value}
            className="risk-list-select"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={riskLevelData || []}
            placeholder="请选择"
            allowClear
            showSearch
            treeNodeFilterProp={'title'}
            treeDefaultExpandAll
            onChange={(e, t, obj) => this.onSelectChange('riskLevel', e, t, obj)}
          />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick} className='risk-list-search-button'>查询</Button>
        </FormItem>
      </Form>
    );
  }
}

MajorHazardsListSearch.propTypes = {
  search: PropTypes.func,
  searchCommonData: PropTypes.array
};

export default MajorHazardsListSearch;
