import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form, Button, Select } from 'amos-framework';

const FormItem = Form.Item;
const Option = Select.Option;

class TaskworkRiskFactorListSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        riskFactorName: {
          name: 'riskFactorName',
          type: 'LIKE',
          value: ''
        },
        riskSourceName: {
          name: 'riskSourceName',
          type: 'LIKE',
          value: ''
        },
        stepName: {
          name: 'stepName',
          type: 'LIKE',
          value: ''
        },
        taskworkName: {
          name: 'taskworkName',
          type: 'LIKE',
          value: ''
        },
        post: {
          name: 'post',
          type: 'LIKE',
          value: ''
        },
        location: {
          name: 'location',
          type: 'LIKE',
          value: ''
        },
        levelId: {
          name: 'levelId',
          type: 'EQUAL',
          value: ''
        },
        methodId: {
          name: 'methodId',
          type: 'EQUAL',
          value: ''
        },
        userId: {
          name: 'userId',
          type: 'EQUAL',
          value: ''
        },
        firstCheckId: {
          name: 'firstCheckId',
          type: 'EQUAL',
          value: ''
        },
        reCheckId: {
          name: 'reCheckId',
          type: 'EQUAL',
          value: ''
        }
      },
      levelData: []
    };
  }

  componentWillMount() {

  }

  componentDidMount() {

  }

  onInputChange =(key,value)=>{
    const { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  }

  onClick =()=>{
    const { form } = this.state;
    this.props.riskSourceSearch(form);
  }

  initFormValues =()=>{
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  }

  render() {
    const { form,levelData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 10 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 12 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 10 }
      }
    };
    return (
      <Form className="risk-list-search" model={form}>
        <FormItem label={<span>危险有害因素名称</span>} field="riskSourceName" {...formItemLayout}>
          <Input value={form.riskSourceName.value} className="risk-list-input" onChange={e => this.onInputChange('riskSourceName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>危险源名称</span>} field="riskSourceName" {...formItemLayout}>
          <Input value={form.riskSourceName.value} className="risk-list-input" onChange={e => this.onInputChange('riskSourceName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>作业活动步骤</span>} field="stepName" {...formItemLayout}>
          <Input value={form.stepName.value} className="risk-list-input" onChange={e => this.onInputChange('stepName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>作业活动名称</span>} field="taskworkName" {...formItemLayout}>
          <Input value={form.taskworkName.value} className="risk-list-input" onChange={e => this.onInputChange('taskworkName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>作业活动岗位</span>} field="post" {...formItemLayout}>
          <Input value={form.post.value} className="risk-list-input" onChange={e => this.onInputChange('post', e.target.value)} />
        </FormItem>
        <FormItem label={<span>作业活动部位</span>} field="location" {...formItemLayout}>
          <Input value={form.location.value} className="risk-list-input" onChange={e => this.onInputChange('location', e.target.value)} />
        </FormItem>
        <FormItem label={<span>风险等级</span>} field="levelId" {...formItemLayout}>
          <Select
            className="risk-list-select"
            data={levelData}
            renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
            value={form.levelId.value}
            onChange={value => this.onInputChange('levelId', value)}
          />
        </FormItem>
        <FormItem label={<span>辨识方法</span>} field="methodId" {...formItemLayout}>
          <Input value={form.methodId.value} className="risk-list-input" onChange={e => this.onInputChange('methodId', e.target.value)} />
        </FormItem>
        <FormItem label={<span>辨识人</span>} field="userId" {...formItemLayout}>
          <Input value={form.userId.value} className="risk-list-input" onChange={e => this.onInputChange('userId', e.target.value)} />
        </FormItem>
        <FormItem label={<span>初评人</span>} field="firstCheckId" {...formItemLayout}>
          <Input value={form.firstCheckId.value} className="risk-list-input" onChange={e => this.onInputChange('firstCheckId', e.target.value)} />
        </FormItem>
        <FormItem label={<span>复评人</span>} field="reCheckId" {...formItemLayout}>
          <Input value={form.reCheckId.value} className="risk-list-input" onChange={e => this.onInputChange('reCheckId', e.target.value)} />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick} className='risk-list-search-button'>查询</Button>
        </FormItem>
      </Form>
    );
  }
}

TaskworkRiskFactorListSearch.propTypes = {
  riskSourceSearch: PropTypes.func
};

export default TaskworkRiskFactorListSearch;
