import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form, Button } from 'amos-framework';

const FormItem = Form.Item;

class SearchView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        controlModelName: {
          name: 'controlModelName',
          type: 'LIKE',
          value: ''
        },
        riskFactorName: {
          name: 'riskFactorName',
          type: 'LIKE',
          value: ''
        },
        riskSourceId: {
          name: 'riskSourceId',
          type: 'EQUAL',
          value: ''
        }
      }
    };
  }

  componentWillMount() {

  }

  componentDidMount() {

  }

  onInputChange =(key,value)=>{
    const { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  }

  onClick =()=>{
    const { form } = this.state;
    this.props.riskSourceSearch(form);
  }

  initFormValues =()=>{
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  }

  render() {
    const { form } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 10 }
      }
    };
    return (
      <Form style={{ width: 270, padding: '30px 0 0' }} className="point-search" model={form}>
        <FormItem label={<span>危险因素</span>} field="riskFactorName" {...formItemLayout}>
          <Input value={form.riskFactorName.value} className="search_Input" onChange={e => this.onInputChange('riskFactorName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>管控对象</span>} field="controlModelName" {...formItemLayout}>
          <Input value={form.controlModelName.value} className="search_Input" onChange={e => this.onInputChange('controlModelName', e.target.value)} />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick}>查询</Button>
        </FormItem>
      </Form>
    );
  }
}

SearchView.propTypes = {
  riskSourceSearch: PropTypes.func
};

export default SearchView;
