import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select, Input } from 'amos-framework';
import AmosGridTable from './../../../common/tableComponent/table/AmosGridTable';
import { getCamerasDataAction, getCamerasTypeAction } from './../../../../../services/bizService';

const Option = Select.Option;

const fireEquipmentTableColumns = self => {
  return [
    {
      title: '序号',
      render: (text, record, index) => `${index + 1}`
    },
    {
      title: '摄像机编号',
      dataIndex: 'code',
      key: 'code',
      width: '10%'
    },
    {
      title: '摄像机名称',
      dataIndex: 'name',
      key: 'name',
      width: '15%'
    },
    {
      title: '摄像机类型',
      dataIndex: 'type',
      key: 'type',
      width: '10%'
    },
    {
      title: '摄像机IP',
      dataIndex: 'ip',
      key: 'ip',
      width: '10%'
    },
    {
      title: '用户名',
      dataIndex: 'username',
      key: 'username',
      width: '10%'
    },
    {
      title: '密码',
      dataIndex: 'password',
      key: 'password',
      width: '10%'
    },
    {
      title: '端口号',
      dataIndex: 'port',
      key: 'port',
      width: '10%'
    },
    {
      title: '通道',
      dataIndex: 'channel',
      key: 'channel',
      width: '10%'
    }
  ];
};

const defaultHeight = 580;

/**
 * 消防设备
 */
class FireStationMatchesAddView extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      pageNumber: 0,
      pageSize: 10
    },
    this.state = {
      form: {
        code: {
          name: 'code',
          type: 'LIKE',
          value: ''
        },
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        type: {
          name: 'type',
          type: 'EQUAL',
          value: ''
        }
      },
      pagination: true,
      selectedRows: [],
      selectedRowKeys: [],
      dataList: [], //表格数据集合
      searchParam: [],
      camerasTypeData: []
    };
  }

  componentDidMount() {
    this.getCamerasTypeData();
  }

  onBtnClick() {
    let { searchParam } = this.state;
    this.getFireEquipmentListData(searchParam);
  }

  onSelectChange(key, value) {
    let { form } = this.state;
    form[key].value = value;
    let searchParam = [];
    for (let key in form ){
      searchParam.push(form[key]);
    }
    this.setState({
      searchParam
    }, () => this.questStatistiscData(this.pageConfig));
  }

  onRowClick = record => {
    let { selectedRowKeys, selectedRows } = this.state;
    let exist = false;
    selectedRows.find(item => {
      if (item.id === record.id) {
        exist = true;
      }
    });
    if (exist) {
      selectedRows.splice(selectedRows.findIndex(item => item.id === record.id), 1);
      selectedRowKeys.splice(selectedRowKeys.findIndex(item => item === record.id), 1);
    } else {
      selectedRows.push(record);
      selectedRowKeys.push(record.id);
    }
    this.setState({
      selectedRows,
      selectedRowKeys
    });
  }

  questStatistiscData = (param, _table) => {
    if (_table && _table.state) {
      _table.state.selectedRowKeys = [];
      _table.state.selectedRows = [];
    }
    const { searchParam } = this.state;
    if (param.current != null) {
      param.pageNumber = param.current;
    }
    const { pageNumber, pageSize } = param;
    this.fetchCamerasData(searchParam,pageNumber,pageSize);
  }

  fetchCamerasData =(searchParam,pageNumber,pageSize)=>{
    getCamerasDataAction(searchParam,pageNumber,pageSize).then(data=>{
      this.setState({ totalCount: data.totalElements,dataList: data.content });
    });
  }

  getPanelHeight = () => {
    return defaultHeight;
  };

  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.current = current;
    }
  };

  getRowClassName = (record, index) => {
    let highlight = this.highlight;
    if (highlight && record.id === highlight) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  };

  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  getCamerasTypeData = () => {
    getCamerasTypeAction().then(data => {
      this.setState({ camerasTypeData: data });
    });
  }

  render() {
    let { form, selectedRowKeys, dataList, totalCount, camerasTypeData } = this.state;
    let _true_ = true;

    return (
      <div className="equipment-fire-equipment" style={{ background: '#33333', height: '100%' }}>
        <div className="equipment-fire-equipment-search">
          <div>
            <span>摄像机类型：</span>
            <Select
              className="cameras-form-select"
              data={camerasTypeData}
              renderOption={item => <Option value={item.code}>{item.name}</Option>}
              value={form.type.value}
              onChange={value => this.onSelectChange('type', value)}
            />
            <span>摄像机编号：</span>
            <Input value={form.code.value} onChange={e => this.onSelectChange('code', e.target.value)} style={{ marginRight: '1rem' }} />
            <span>摄像机名称：</span>
            <Input value={form.name.value} onChange={e => this.onSelectChange('name', e.target.value)} />
          </div>
        </div>
        <AmosGridTable
          rowKey="id"
          columns={fireEquipmentTableColumns(this)}
          callBack={this.reload}
          dataList={dataList}
          totals={totalCount}
          getTableDataAction={this.questStatistiscData}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          getPanelHeight={this.getPanelHeight}
          defaultPageConlHeight={this.getPanelHeight}
          isChecked={_true_}
          selectedRowKeys={selectedRowKeys}
          onRowClick={this.onRowClick}
        />
      </div>
    );
  }
}

FireStationMatchesAddView.propTypes = {
  totalCount: PropTypes.number,
  dataList: PropTypes.array,
  getTableListData: PropTypes.func
};
export default FireStationMatchesAddView;
