import React, { Component } from 'react';
import AmosGridTable from './../../common/tableComponent/table/AmosGridTable';
import { getTaskworkTypeDataAction } from './../../../../services/bizService';
import PropTypes from 'amos-react-router/lib/PropTypes';

const getColumns = (self) => {
  return [
    {
      title: '步骤顺序',
      dataIndex: 'serialNum',
      key: 'serialNum',
      width: '15%',
      className: 'uant-table-thead'
    },
    {
      title: '作业活动步骤',
      dataIndex: 'content',
      key: 'content',
      width: '85%',
      className: 'uant-table-thead'
    }
  ];
};

class TaskworkView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      dataList: [],
      taskworkTypeData: []
    };
  }

  componentDidMount() {
    this.getTaskworkTypeData();
  }

  getTaskworkTypeData() {
    getTaskworkTypeDataAction().then(data => {
      this.setState({ taskworkTypeData: data });
    });
  }

  getTypeName = (type) => {
    const { taskworkTypeData } = this.state;
    if (taskworkTypeData && taskworkTypeData.length > 0) {
      const o = taskworkTypeData.find(item => item.dictDataKey === type);
      return o.dictDataValue;
    }
    return '';
  }

  render() {
    const { taskwork } = this.props;
    const dataList = taskwork && taskwork.contentList;
    return (
      <div className="taskwork-content-detail">
        <div className="basic-info" style={{ display: 'flex' }}>
          <div style={{ flex: 1 }}>
            <span style={{ fontWeight: 100 }}>作业活动名称：</span>
            <span style={{ fontSize: '15px' }}>{taskwork.name || ''}</span>
            <br />
            <span style={{ fontWeight: 100 }}>作业活动岗位：</span>
            <span style={{ fontSize: '15px' }}>{taskwork.post || ''}</span>
            <br />
            <span style={{ fontWeight: 100 }}>作业活动部位：</span>
            <span style={{ fontSize: '15px' }}>{taskwork.part || ''}</span>
            <br />
            <span style={{ fontWeight: 100 }}>作业活动类型：</span>
            <span style={{ fontSize: '15px' }}>{this.getTypeName(taskwork.type) || ''}</span>
          </div>
          <div style={{ flex: 1 }}>
            <span style={{ fontWeight: 100 }}>所属风险区域：</span>
            <span style={{ fontSize: '15px' }}>{taskwork.regionName || ''}</span>
            <br />
            <span style={{ fontWeight: 100 }}>车间/部门：</span>
            <span style={{ fontSize: '15px' }}>{taskwork.departmentName || ''}</span>
            <br />
            <span style={{ fontWeight: 100 }}>班组：</span>
            <span style={{ fontSize: '15px' }}>{taskwork.groupName || ''}</span>
          </div>

        </div>
        <div className="content-info" style={{ paddingTop: '20px' }}>
          <span>作业活动步骤</span>
          <AmosGridTable
            columns={getColumns(this)}
            callBack={() => {}}
            isPageable={false}
            dataList={dataList}
            totals={dataList ? dataList.length : 0}
            getTableDataAction={() => {}}
            isChecked={false}
          />
        </div>
      </div>
    );
  }
}

TaskworkView.propTypes = {
  taskwork: PropTypes.object
};

export default TaskworkView;
