import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { IFrame } from 'amos-framework';
import { Store } from 'amos-tool';
import SysConsts from 'amos-processor/lib/config/consts';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { getOutterURL } from '../../../../consts/urlConsts';

const lsTool = Store.lsTool;

/**
 * 工作流程图
 *
 * @class WorkFlowStatus
 * @extends {Component}
 */
class WorkFlowStatus extends Component {
  constructor(props) {
    super(props);

  }

  componentWillMount() {

  }

  render() {
    const { instanceId } = this.props;
    let url = getOutterURL('workFlowURI');
    url = `${url}/wf/processes/${instanceId}/diagram/?token={token}`;
    let token = lsTool.read(SysConsts.token);
    url = formatUrl(url, { token });
    return (
      <div className="rule-model">
        <img src={url}  alt='' />
      </div>
    );
  }
}

WorkFlowStatus.propTypes = {
  instanceId: PropTypes.number
};

export default WorkFlowStatus;
