import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosGridTable from './../../../common/tableComponent/table/AmosGridTable';
import { controlMeasureDetailAction, getCatalogEumAction, getTypeEumAction } from '../../../../../services/bizService';

const getColumns = (self) => {
  return [
    {
      title: '序号',
      render: (text, record, index) => `${index + 1}`
    },
    {
      title: '控制措施内容',
      dataIndex: 'content',
      key: 'content',
      width: '50%',
      className: 'uant-table-thead'
    },
    {
      title: '标准依据',
      dataIndex: 'basis',
      key: 'basis',
      width: '40%',
      className: 'uant-table-thead',
      render: (text, record) => {
        let basisValues = JSON.parse(record.basis);
        return basisValues && basisValues.map(item => {
          return (
            <div>
              {item.name}
            </div>
          );
        });
      }
    }
  ];
};

class MeasuresView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      dataList: [],
      catalogEnumData: [],
      typeEnumData: []
    };
  }

  componentWillMount() {
    this.getCatalogEnumData();
    this.getTypeEnumData();
  }

  componentDidMount() {
    const { mesId } = this.props;
    mesId && this.getMeaSuresDetailById(mesId);
  }

  getCatalogEnumData = () => {
    getCatalogEumAction().then(data => {
      this.setState({ catalogEnumData: data });
    });
  }

  getTypeEnumData = () => {
    getTypeEumAction().then(data => {
      this.setState({ typeEnumData: data });
    });
  }

  getMeaSuresDetailById =(id)=>{
    controlMeasureDetailAction(id).then(data => {
      this.setState({ dataList: data.detailCxt, name: data.name, type: data.type, category: data.category });
    });
  }

  getTypeName = (typeEnumData, type) => {
    let typeObj = {};
    typeEnumData && (typeObj = typeEnumData.find(item => item.dictDataKey === type));
    return typeObj && typeObj.dictDataValue;
  }

  getCatalogName = (catalogEnumData, category) => {
    let catalogObj = {};
    catalogEnumData && (catalogObj = catalogEnumData.find(item => item.dictDataKey === category));
    return catalogObj && catalogObj.dictDataValue;
  }

  render() {
    const { dataList, name, type, category, typeEnumData, catalogEnumData } = this.state;
    let _true_ = false;
    return (
      <div className="control-model-measures-detail">
        <div className="basic-info">
          <div>
            <span style={{ fontWeight: 100 }}>控制措施名称：</span>
            <span style={{ fontSize: '15px' }}>{name || ''}</span>
            <span style={{ fontWeight: 100, paddingLeft: '50px' }}>所属类型：</span>
            <span style={{ fontSize: '15px' }}>{this.getTypeName(typeEnumData, type) || ''}</span>
          </div>
          <span style={{ fontWeight: 100 }}>控制措施类别：</span>
          <span style={{ fontSize: '15px' }}>{this.getCatalogName(catalogEnumData, category) || ''}</span>
        </div>
        <div className="patrol-page-table">
          <span>控制措施内容</span>
          <AmosGridTable
            columns={getColumns(this)}
            callBack={() => {}}
            isPageable={_true_}
            dataList={dataList}
            totals={dataList ? dataList.length : 0}
            getTableDataAction={() => {}}
            isChecked={false}
          />
        </div>
      </div>
    );
  }
}

MeasuresView.propTypes = {
  mesId: PropTypes.number
};

export default MeasuresView;
