import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form } from 'amos-framework';

const FormItem = Form.Item;

/**
 * 危险源分类查询页面
 *
 * @class DangerSourceClassifySearch
 * @extends {Component}
 */
class DangerSourceClassifySearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        type: {
          name: 'type',
          type: 'LIKE',
          value: ''
        },
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        describe: {
          name: 'describe',
          type: 'LIKE',
          value: ''
        }
      }
    };
  }

  componentDidMount() {

  }

  componentWillReceiveProps(nextProps) {

  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  };

  initSearchFileds = () => {
    let { form } = this.state;
    for (let k in form) {
      form[k].value = '';
    }
    this.setState({ form });
  }

  render() {
    const { form } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0px', marginLeft: 'auto' }} className="point-search" model={form}>
        <FormItem label={<span>危险源类别</span>} field="type" {...formItemLayout}>
          <Input value={form.type.value} className="search_Input" onChange={e => this.onChange('type', e)} />
        </FormItem>
        <FormItem label={<span>类别名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label={<span>类别详情</span>} field="describe" {...formItemLayout}>
          <Input value={form.describe.value} className="search_Input" onChange={e => this.onChange('describe', e)} />
        </FormItem>
      </Form>
    );
  }
}

DangerSourceClassifySearch.propTypes = {

};

export default DangerSourceClassifySearch;
