import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import BizIcon from './../../../../common/icon/BizIcon';

/**
 * 工具栏
 *
 * @class DangerSourceClassifyToolBar
 * @extends {Component}
 */

class DangerSourceClassifyToolBar extends Component {
  constructor(props) {
    super(props);
  }

  componentWillMount() {}

  onClick = (e, value) => {
    let { onButtonClick } = this.props;
    onButtonClick(value);
  };

  onChange = (e, value) => {
    let { searchTableDate } = this.props;
    this.setState({ name: value });
    let searchParam = [{ name: e, value }];
    searchTableDate(searchParam);
  };

  render() {
    return (
      <div className="accident-type-toolbar">
        <div className="accident-search-button">
          <Button title="添加" icon={<BizIcon icon="tianjia" />} transparent onClick={e => this.onClick(e, '1')} />
          <Button title="修改" icon={<BizIcon icon="xiugai" />} transparent onClick={e => this.onClick(e, '2')} />
          <Button title="删除" icon={<BizIcon icon="shanchu" />} transparent onClick={e => this.onClick(e, '3')} />
          <Button title="筛选" icon={<BizIcon icon="shaixuan" />} transparent onClick={e => this.onClick(e, '4')} />
        </div>
      </div>
    );
  }
}

DangerSourceClassifyToolBar.propTypes = {
  onButtonClick: PropTypes.func,
  searchTableDate: PropTypes.func
};

export default DangerSourceClassifyToolBar;
