import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import BizIcon from './../../../../common/icon/BizIcon';

/**
 * 工具栏
 *
 * @class RiskFactorToolBar
 * @extends {Component}
 */

class RiskFactorToolBar extends Component {
  constructor(props) {
    super(props);
  }

  componentWillMount() {}

  onClick = (e, value) => {
    let { onButtonClick } = this.props;
    onButtonClick(value);
  };

  onChange = (e, value) => {
    let { searchTableDate } = this.props;
    this.setState({ name: value });
    let searchParam = [{ name: e, value }];
    searchTableDate(searchParam);
  };

  render() {
    return (
      <div className="risk-factor-toolbar">
        <div className="risk-factor-button">
          <Button title="添加" icon={<BizIcon icon="tianjia" />} transparent onClick={e => this.onClick(e, '1')} />
          <Button title="修改" icon={<BizIcon icon="xiugai" />} transparent onClick={e => this.onClick(e, '2')} />
          <Button title="删除" icon={<BizIcon icon="shanchu" />} transparent onClick={e => this.onClick(e, '3')} />
          <Button title="筛选" icon={<BizIcon icon="shaixuan" />} transparent onClick={e => this.onClick(e, '4')} />
        </div>
      </div>
    );
  }
}

RiskFactorToolBar.propTypes = {
  searchTableDate: PropTypes.func,
  onButtonClick: PropTypes.func
};

export default RiskFactorToolBar;
