import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Pagination } from 'amos-framework';
import ExecuteLineItem from './ExecuteLineItem';

/**
 * 检查执行情况体
 *
 * @class CheckExecuteBody
 * @extends {Component}
 */
class CheckExecuteBody extends Component {
  constructor(props) {
    super(props);

  }

  componentWillMount() {

  }

  componentDidMount() {

  }

  onPageChange = (page) => {
    const { onPageChange } = this.props;
    onPageChange && onPageChange(page);
  }

  renderList = (data)=>{
    return data.map(item=>{
      return <ExecuteLineItem key={item.id} lineData={item} />;
    });
  }

  render() {
    const { dataList = [],totalPageNum, pageSize } = this.props;
    return (
      <div className='check-execute-body' >
        {this.renderList(dataList)}
        {dataList.length > 0 ? <Pagination
          currentPage={1}
          className='check-execute-pagination'
          totalPageNum={totalPageNum}
          pageSize={pageSize}
          maxSeries={3}
          hideSizeChanger
          hideAssistant
          hideJumper
          onPageChange={this.onPageChange}
        /> : <div style={{ textAlign: 'center' }}>暂无数据</div>
        }
      </div>
    );
  }
}

CheckExecuteBody.propTypes = {
  dataList: PropTypes.array,
  totalPageNum: PropTypes.number,
  pageSize: PropTypes.number,
  onPageChange: PropTypes.func
};

export default CheckExecuteBody;
