import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select } from 'amos-framework';
import BizIcon from '../../../../view/common/icon/BizIcon';
import { getRegionDepartmentTreeAction } from '../../../../services/bizService';

const Option = Select.Option;

/**
 * 检查执行情况头
 *
 * @class CheckExecuteHeader
 * @extends {Component}
 */
class CheckExecuteHeader extends Component {
  constructor(props) {
    super(props);
    this.state = {
      deptData: []
    };

  }

  componentWillMount() {

  }

  componentDidMount() {
    this.getAreaData();
  }

  onChange =(value)=>{
    const { filter } = this.props;
    filter && filter(value || '');
  }

  getAreaData = () => {
    getRegionDepartmentTreeAction().then(data => {
      let allData = data.secondDepartments;
      let dData = [];
      for (let key in allData) {
        dData.push(...allData[key]);
      }
      let deptData = [];
      dData && dData.map(item => {
        let deptObj = {};
        deptObj.id = item.sequenceNbr;
        deptObj.name = item.departmentName;
        deptData.push(deptObj);
      });
      this.setState({ deptData });
    });
  }

  render() {
    const { deptData } = this.state;
    return (
      <div className='check-execute-header' >
        <BizIcon icon='mokuaidian' className='check-execute-header-icon' />
        <span>当前检查计划执行情况</span>
        <Select
          data={deptData}
          className='check-execute-header-select'
          renderOption={item => <Option value={item.id}>{item.name}</Option>}
          defaultOption={<Option >部门</Option>}
          onChange={this.onChange}
          minWidth={110}
        />
      </div>
    );
  }
}

CheckExecuteHeader.propTypes = {
  filter: PropTypes.func
};

export default CheckExecuteHeader;
