import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import BizIcon from '../../../../view/common/icon/BizIcon';
import { getDangerDataByDeptAction } from './../../../../services/situationService';


class DangerStatisticsHistogram extends Component {
  constructor(props) {
    super(props);
    this.state = {
      seriesData: []
    };
  }

  componentDidMount() {
    this.getDangerStatisticsData();
  }

  componentWillReceiveProps(nextProps) {
    if (!nextProps.refreshData) {
      return;
    } else {
      let { content } = nextProps.refreshData;
      if (content && content === 'dangerExecute') {
        this.getDangerStatisticsData();
      }
    }
  }

  getDangerStatisticsData = () => {
    getDangerDataByDeptAction().then(data => {
      console.log('dangerExecute sucdess');
      this.setState({ seriesData: data });
    });
  }

  getOptions = (obj) => {
    obj && obj.series && obj.series.map(item => {
      item.barWidth = 10;
      // item.label && delete item.label;
    });
    return {
      tooltip: {
        trigger: 'axis',
        axisPointer: {
          // 坐标轴指示器，坐标轴触发有效
          type: 'shadow' // 默认为直线，可选为：'line' | 'shadow'
        }
      },
      grid: {
        left: '3%',
        right: '4%',
        bottom: '5%',
        top: '7%',
        containLabel: true
      },
      yAxis: {
        type: 'value',
        axisTick: {
          show: false
        },
        axisLine: {
          show: false
        },
        splitLine: {
          show: true,
          lineStyle: {
            type: 'dashed'
          }
        }
      },
      xAxis: {
        type: 'category',
        axisTick: {
          show: false
        },
        axisLine: {
          lineStyle: {
            color: '#eaeaea'
          }
        },
        axisLabel: {
          interval: 0,
          textStyle: {
            color: '#666666'
          }//,
          // formatter: (value) => {
          //   return value.split('').join('\n');
          // }
        },
        data: (obj && obj.xAxisData) || []
      },
      color: ['#ffcc33','#f16060'],
      series: (obj && obj.series) || []
    };
  };

  render() {
    let { seriesData } = this.state;
    return (
      <div className="danger-statistics-histogram">
        <div className="title">
          <BizIcon icon='mokuaidian' className='check-execute-header-icon' />
          <span>隐患按车间/部门统计</span>
        </div>
        <AmosEcharts option={this.getOptions(seriesData)} />
      </div>
    );
  }
}

DangerStatisticsHistogram.propTypes = {
  refreshData: PropTypes.object
};

export default DangerStatisticsHistogram;
