import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import BizIcon from '../../../../view/common/icon/BizIcon';

class DynamicRiskIndexPie extends Component {
  constructor(props) {
    super(props);
    this.state = {
      indexData: []
    };
  }

  componentDidMount() {

  }

  getOptions = (obj) => {
    let data = [];
    let data1 = {};
    let data2 = {};
    obj.countOfSource = 4000;
    obj.countOfType0 = 1600;
    data1.value = obj.countOfType0;
    data2.value = obj.countOfSource - obj.countOfType0;
    data1.name = obj.countOfType0 + '\r\n' + '动态风险';
    data2.name = '';
    data.push(data1);
    data.push(data2);

    return {
      color: ['#3aa1fe', 'lightgray'],
      series: [
        {
          name: '动态风险',
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              color: 'black',
              position: 'center',
              formatter: '{b}',
              fontSize: 16
            }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data
        }
      ]
    };
  }

  render() {
    let { indexData } = this.state;
    return (
      <div className="dynamic-dashboard" >
        <div className="title">
          <BizIcon icon='mokuaidian' className='check-execute-header-icon' />
          <span>动态风险指数仪表盘</span>
        </div>
        <div style={{ height: '185px' }}>
          <AmosEcharts option={this.getOptions(indexData)} />
        </div>
      </div>
    );
  }
}

DynamicRiskIndexPie.propTypes = {

};

export default DynamicRiskIndexPie;
