import React, { Component } from 'react';
import PropTypes from 'prop-types';
import TaskList from './taskList';
import CurDangerCount from './CurDangerCount'
import MonthDangerCount from './MonthDangerCount'
import YearDangerCount from './YearDangerCount'
import moment from 'moment';
import { fetchHidDangerCountAction  } from './../../../services/checkInfoService';


class TaskView extends Component {
      constructor(props) {
        super(props);
        this.state ={
           curData:[],
           monData:[],
           yearData:[],
           countDate:{},
           point:{},
           flag:''
        }
      }

  componentWillMount() {
    if (this.props.location.state) {
      this.setState({point:this.props.location.state.point || {}});
    }
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps) {
      if (nextProps.location.state) {    
        this.setState({point:nextProps.location.state.point || {},flag:'forword'});
      }
    }
  }
  componentDidMount() {
    this.questStatisXJCountData();
 
  }
  questStatisXJCountData = () => {
    const countDate =  moment().format('YYYYMMDD');
    fetchHidDangerCountAction(countDate).then(data => {
      data && this.setState({
        curData:data.curConutList,
        monData:data.monthConutList,
        yearData:data.yearConutList,
        countDate:countDate
      });
    });
  };
  render() {   
    let {curData,monData ,yearData,countDate,point,flag} = this.state;
    return (
      <div className='point-view'>
        <div className="point-first-row">
         <CurDangerCount  curData ={curData} />
         <MonthDangerCount monData ={monData} countDate ={countDate}/>
         <YearDangerCount  yearData ={yearData}/>
        </div>
         <TaskList point={point} flag ={flag}/>
      </div>
    );
  }
}

TaskView.propTypes = {

};
export default TaskView;
