import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select, DatePicker } from 'amos-antd';
import { fetchTaskQueryCriteria } from './../../../services/checkInfoService';

const Option = Select.Option;
const { RangePicker } = DatePicker;

/**
 *
 *
 * @class TaskSearch
 * @extends {Component}
 */
class TaskSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      checkUserOptions: [],
      dataPointOptions: [],
      statusOptions: [],
      searchParam: {},
      defaultPointValue: ''
    };
  }
  componentWillMount() {
    this.setState({ defaultPointValue: this.props.point.name });
  }

  componentDidMount() {
    this.getSearchConditionAction();
  }

  onSelectedChange = (value, type) => {
    let { searchParam } = this.state;
    if (type === 'time') {
      let startTime, endTime;
      if (value.length !== 0) {
        startTime = value[0].format('YYYY-MM-DD');
        endTime = value[1].format('YYYY-MM-DD');
      }
      searchParam['startTime'] = startTime;
      searchParam['endTime'] = endTime;
    } else {
      searchParam[type] = value;
    }
    this.setState({ searchParam });
    Object.assign(searchParam, { pageNumber: 0, pageSize: 10 });
    searchParam && this.props.setSearchParam(searchParam);
  };

  //查询任务相关人员
  getSearchConditionAction = () => {
    fetchTaskQueryCriteria().then(data => {
      let userlist = [];
      let pointList = [];
      let statusList = [];
      let defaultPointValue = '';
      data.points
        ? data.points.map(e => {
            // if(e.pointID==this.props.pointId){
            //    defaultPointValue = e.name
            // }
          pointList.push(<Option value={`${e.id}`}>{e.name}</Option>);
        })
        : [];

      data.status
        ? data.status.map(e => {
          statusList.push(<Option value={`${e.value}`}>{e.name}</Option>);
        })
        : [];

      data.users
        ? data.users.map(e => {
          userlist.push(<Option value={`${e.id}`}>{e.name}</Option>);
        })
        : [];

      this.setState({ checkUserOptions: userlist, dataPointOptions: pointList, statusOptions: statusList });
    });
  };

  searchData = () => {
    let { searchParam } = this.state;
    Object.assign(searchParam, { pageNumber: 0, pageSize: 10 });
    searchParam && this.props.setSearchParam(searchParam);
  };

  render() {
    const { searchParam } = this.props;
    let { checkUserOptions, dataPointOptions, statusOptions } = this.state;
    return (
      <div className="create-device-search-root">
        <div className="catalog-select">
          <Select
            style={{ width: '150px' }}
            dropdownStyle={{ width: '150px' }}
            dropdownMatchSelectWidth
            onChange={e => this.onSelectedChange(e, 'pointId')}
            placeholder="巡检点"
            allowClear
            value={searchParam['pointId']}
          >
            {dataPointOptions}
          </Select>
        </div>

        <div className="catalog-select">
          <Select
            style={{ width: '150px' }}
            dropdownStyle={{ width: '150px' }}
            dropdownMatchSelectWidth
            onChange={e => this.onSelectedChange(e, 'userId')}
            placeholder="人员"
            allowClear
          >
            {checkUserOptions}
          </Select>
        </div>
        <div className="catalog-select">
          <Select
            style={{ width: '150px' }}
            dropdownStyle={{ width: '150px' }}
            dropdownMatchSelectWidth
            onChange={e => this.onSelectedChange(e, 'status')}
            placeholder="状态"
            allowClear
          >
            {statusOptions}
          </Select>
        </div>
        <div className="catalog-select">
          <RangePicker
            onChange={e => {
              this.onSelectedChange(e, 'time');
            }}
          />
        </div>
      </div>
    );
  }
}

TaskSearch.propTypes = {
  setSearchParam: PropTypes.func
};

export default TaskSearch;
