import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import { Select, Input, DatePicker } from 'amos-antd';
import { browserHistory } from 'amos-react-router/lib';
import { checkStatusEnum } from './../xjcheck/common/CheckEnum';
import { enums2array } from './../xjcheck/common/CheckLang';
import { fetchXJUserInfoAction } from './../../../services/checkInfoService';
import BizIcon from './../../common/icon/BizIcon';

const Option = Select.Option;

const dataTypeOption = enums2array(checkStatusEnum).map(item => (
  <Option key={item.key} value={`${item.label}`}>
    {item.label}
  </Option>
));
/**
 *
 *
 * @class XJCheckSearch
 * @extends {Component}
 */
class XJCheckSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      checkUserOptions: [],
      searchParam: {},
      modelOptions: []
    };
  }
  componentWillMount() {
    this.questStatisXJUesrData();
  }

  componentDidMount() {
    // this.questStatisXJUesrData();
  }

  componentWillReceiveProps(nextProps) {}

  componentWillUnmount() {}

  onChange = e => {
    let { searchParam } = this.state;
    searchParam['userName'] = e.target.value;
    this.setState({ searchParam });
  };

  onSelectedChange = (value, type) => {
    let { searchParam } = this.state;
    searchParam[type] = value;
    this.setState({ searchParam });
    Object.assign(searchParam,{ pageNumber: 0, pageSize: 10 });
    searchParam && this.props.setSearchParam(searchParam);
  };

  //查询巡检人员
  questStatisXJUesrData = () => {
    // let pd = this.props.pointID;
    let pd = '11';
    if (pd === undefined && window.sessionStorage.getItem('checkDetailHis')) {//从巡检记录详情页返回时
      let sessionJsonStr = window.sessionStorage.getItem('checkDetailHis');
      if (JSON.parse(sessionJsonStr)) {
        pd = JSON.parse(sessionJsonStr).pointID;
      }
    }

    if (pd !== undefined) {

      fetchXJUserInfoAction(pd).then(data => {
        let xjuserPlist = [];
        data
        ? data.map(e => {
          xjuserPlist.push(<Option value={`${e.UserID}`}>{e.realName}</Option>);
        })
        : [];
        this.setState({ checkUserOptions: xjuserPlist });
      });
    }
  };

  searchData = () => {
    let { searchParam } = this.state;
    Object.assign(searchParam, { pageNumber: 0, pageSize: 10 });
    searchParam && this.props.setSearchParam(searchParam);
  };

  goBackAction = () => {
    browserHistory.push('/biz/patrolpoint');
  };

  render() {
    let { checkUserOptions } = this.state;
    return (
      <div className="create-device-search-root">
        <div className="catalog-select">
          <Select
            style={{ width: '170px' }}
            dropdownStyle={{ width: '170px' }}
            dropdownMatchSelectWidth
            onChange={e => this.onSelectedChange(e, 'status')}
            placeholder="巡检状态"
            allowClear
          >
            {dataTypeOption}
          </Select>
        </div>
        <div className="catalog-select">
          <Select
            style={{ width: '170px' }}
            dropdownStyle={{ width: '170px' }}
            dropdownMatchSelectWidth
            onChange={e => this.onSelectedChange(e, 'userID')}
            placeholder="巡检人员"
            allowClear
          >
            {checkUserOptions}
          </Select>
        </div>
        <div className="search-device">
          <Input placeholder="请输入搜索内容" onChange={this.onChange} onPressEnter={this.searchData} style={{ width: '150px', 'border-radius': '10px' }} />
          <img src={require('./../../../assets/fsc/check/search.png')} alt="" onClick={this.searchData} />
        </div>
        <div
          className="check-detail-header-goback"
          // onClick={() => {
          //   this.goBackAction();
          // }}
        >
          {/*<img src={require('./../../../assets/fsc/check/back.png')} alt="" />*/}
          <Button icon={<BizIcon icon="fanhui" />} transparent onClick={() => this.goBackAction()}  />
        </div>
      </div>
    );
  }
}

XJCheckSearch.propTypes = {
  setSearchParam: PropTypes.func,
  pointID: PropTypes.string
};

export default XJCheckSearch;
